/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: SetJspIdTag.java 62554 2011-04-15 18:08:28Z dougd $
 */

package com.sun.ts.tests.jsp.api.javax_servlet.jsp.tagext.jspidconsumer;

import com.sun.ts.tests.jsp.common.util.JspTestUtil;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.JspIdConsumer;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import java.io.IOException;

public class SetJspIdTag extends SimpleTagSupport 
        implements JspIdConsumer {

    private String jspId;
    private JspWriter out;
 
    public void setJspId(String id) {
        jspId = id;
    }

    public void doTag() throws JspException, IOException {

        out = getJspContext().getOut();

        try {
            if (jspId == null) {
                out.println("No ID assigned. Test FAILED");
                return;
            }
            out.println("JspId is " + jspId);
            if (isConformant()) {
                out.println("Test PASSED");
            }
        } catch (Throwable t) {
            JspTestUtil.handleThrowable(t, out, "SetJspIdTag");
        }
    }

    private boolean isConformant() throws IOException {

        char firstChar = jspId.charAt(0);

        if (!Character.isLetter(firstChar) && firstChar != '_') {
            out.println("First character of ID is not letter or underscore");
            return false;
        }

        for (int i = 1; i < jspId.length(); ++i) {
            char ch = jspId.charAt(i);
            if (!Character.isLetter(ch) &&
                    !Character.isDigit(ch) &&
                    ch != '-' &&
                    ch != '_') {
                out.print("character " + i + " is neither letter, "); 
                out.println("digit, dash, or underscore");
                return false;
            }
        }
        return true;
    }
}
