/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: SimpleGetSetJspBody.java 62554 2011-04-15 18:08:28Z dougd $
 */

/*
 * @(#)SimpleGetSetJspBody.java 1.1 10/31/02
 */
 
package com.sun.ts.tests.jsp.api.javax_servlet.jsp.tagext.simpletagsupport;

import com.sun.ts.tests.jsp.common.util.JspTestUtil;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import javax.servlet.jsp.tagext.JspFragment;
import javax.servlet.jsp.JspException;
import java.io.IOException;

public class SimpleGetSetJspBody extends SimpleTagSupport {

    /**
     * Default constructor.
     */
    public SimpleGetSetJspBody() {
        super();
    }

    /**
     * Validate that getJspBody() returns a non null value.
     * This indirectly ensures that the container properly called
     * setJspBody().
     * @throws JspException - if an unexpected error occurs
     * @throws IOException - if an unexpected I/O error occurs
     */
    public void doTag()
        throws JspException, IOException {
        JspTestUtil.debug("[SimpleGetSetJspBody] in doGet()");
        JspFragment fragment = this.getJspBody();
        if (fragment != null) {
            this.getJspContext().getOut().println("Test PASSED");
        } else {
            this.getJspContext().getOut().println("Test FAILED.  JspContext.getJspBody()" +
                " returned a null value.");
        }
    }
}
