/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: SimpleGetSetParent.java 62554 2011-04-15 18:08:28Z dougd $
 */

/*
 * @(#)SimpleGetSetParent.java 1.1 10/31/02
 */
 
package com.sun.ts.tests.jsp.api.javax_servlet.jsp.tagext.simpletagsupport;

import com.sun.ts.tests.jsp.common.util.JspTestUtil;

import javax.servlet.jsp.tagext.SimpleTagSupport;
import javax.servlet.jsp.tagext.JspTag;
import javax.servlet.jsp.tagext.SimpleTag;
import javax.servlet.jsp.JspException;
import java.io.IOException;

public class SimpleGetSetParent extends SimpleTagSupport {

    /**
     * Default constructor.
     */
    public SimpleGetSetParent() {
        super();
    }

    /**
     * Validates that getParent() returns the expected result.  This indirectly
     * ensures that the container called setParent().
     * @throws JspException
     * @throws IOException
     */
    public void doTag()
        throws JspException, IOException {
        JspTestUtil.debug("[SimpleGetSetParent] in doTag()");
        JspTag tag = this.getParent();
        if (tag != null) {
            if (tag instanceof SimpleTag) {
                this.getJspContext().getOut().println("Test PASSED");
            } else {
                this.getJspContext().getOut().println("Test FAILED.  SimpleTagSupport" +
                    ".getParent() returned a non-null value, but was not an instance " +
                    "of the expected parent class.  Recieved: " + tag.getClass().getName());
            }
        } else {
            this.getJspContext().getOut().println("Test FAILED.  SimpleTagSupport" +
                ".getParent() returned null.");
        }
    }
}
