/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: SimpleSyncTag.java 62554 2011-04-15 18:08:28Z dougd $
 */

/*
 * @(#)SimpleSyncTag.java 1.1 11/06/02
 */
 
package com.sun.ts.tests.jsp.api.javax_servlet.jsp.tagext.simpletagsupport;

import javax.servlet.jsp.tagext.SimpleTagSupport;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspContext;
import java.io.IOException;

/**
 * SimpleTag instance to validate variable synchronization
 * with SimpleTag's declared in the TLD.
 */
public class SimpleSyncTag extends SimpleTagSupport {

    /**
     * Default constructor.
     */
    public SimpleSyncTag() {
        super();
    }

    /**
     * Export PageContext variables to be synced with TEI declared
     * variables.
     * @throws JspException if an error occurs
     * @throws IOException if an I/O error occurs
     */
    public void doTag()
        throws JspException, IOException {
        JspContext context = this.getJspContext();
        Integer begin = (Integer) context.getAttribute("begin");
        Integer end = (Integer) context.getAttribute("end");
        if (begin == null) {
            context.setAttribute("begin", Integer.valueOf(1));
        } else {
            context.setAttribute("begin", Integer.valueOf(begin.intValue() + 1));
        }
        if (end == null) {
            context.setAttribute("end", Integer.valueOf(2));
        } else {
            context.setAttribute("end", Integer.valueOf(end.intValue() + 1));
        }
    }
}
