/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jsp.common.util;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import javax.el.CompositeELResolver;

/**
 * ServletContextListener that installs 
 * a CompositeELResolver.
 */
public class InstallCompositeELResolverListener 
    implements ServletContextListener
{
    public static CompositeELResolver compResolver;

    public void contextInitialized(ServletContextEvent evt) {
        
        compResolver = new CompositeELResolver();
        ServletContext context = evt.getServletContext();
        JspApplicationContext jspContext = 
            JspFactory.getDefaultFactory().getJspApplicationContext(context);
        jspContext.addELResolver(compResolver);
        
    }
    
    public void contextDestroyed(ServletContextEvent evt) {
    }

    public static CompositeELResolver getCompositeELResolver() {
        return compResolver;
    }
}
