/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: SimpleAttributeTestTag.java 62554 2011-04-15 18:08:28Z dougd $
 */
 
package com.sun.ts.tests.jsp.spec.core_syntax.actions.attribute;

import javax.servlet.jsp.tagext.SimpleTagSupport;
import javax.servlet.jsp.tagext.DynamicAttributes;
import javax.servlet.jsp.tagext.JspFragment;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import java.io.IOException;

public class SimpleAttributeTestTag extends SimpleTagSupport
implements DynamicAttributes {

    Object _fragment = null;
    Object _dynamic = null;

    public void setFragment(Object o) {
        _fragment = o;
    }
    public void doTag() throws JspException, IOException {
        if (_fragment != null) {
            JspWriter out = getJspContext().getOut();
            try {
                if (_fragment instanceof JspFragment) {
                    out.println("Test PASSED");
                } else {
                    out.println("Object passed to the fragment attribute was not" +
                        "an instance of JspFragment.  Actual type: " +
                        _fragment.getClass().getName());
                }
            } catch (IOException ioe) {
                throw new JspException("Unexpected IOException!", ioe);
            }
        } else if (_dynamic != null) {
            JspWriter out = getJspContext().getOut();
            try {
                if (_dynamic instanceof String) {
                    out.println("Test PASSED");
                } else {
                    out.println("Object passed to the fragment attribute was not" +
                        "an instance of String.  Actual type: " +
                        _fragment.getClass().getName());
                }
            } catch (IOException ioe) {
                throw new JspException("Unexpected IOException!", ioe);
            }
        }
    }

    public void setDynamicAttribute(String s, String s1, Object o) throws JspException {
        _dynamic = o;
    }
}
