/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: SimpleBodyTag.java 62554 2011-04-15 18:08:28Z dougd $
 */
 
package com.sun.ts.tests.jsp.spec.core_syntax.actions.body;

import javax.servlet.jsp.tagext.SimpleTagSupport;
import javax.servlet.jsp.tagext.JspFragment;
import javax.servlet.jsp.tagext.DynamicAttributes;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import java.io.IOException;
import java.io.StringWriter;

public class SimpleBodyTag extends SimpleTagSupport implements DynamicAttributes {

    public void setDynamicAttribute(String s, String s1, Object o)
    throws JspException {
        // no-op
    }

    public void doTag() throws JspException, IOException {
        JspFragment body = getJspBody();
        if (body != null) {
            StringWriter writer = new StringWriter();
            body.invoke(writer);
            String bodyValue = writer.toString().trim();
            JspWriter out = getJspContext().getOut();
            if ("testpassed".equals(bodyValue)) {
                out.println("Test PASSED");
            } else {
                out.println("Test FAILED.  Expected body to be 'testpassed'." +
                    "  Received: " + bodyValue);
            }
        }
    }
}
