/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jsp.spec.el.language;

import com.sun.ts.tests.jsp.common.util.JspTestUtil;
import javax.el.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import java.io.*;

public class PoundDollarSameMeaningTag extends SimpleTagSupport {

    private String dollarValue;
    private ValueExpression poundExpr;

    public void setDollarExpr(String dollarExpr) {
        this.dollarValue = dollarExpr;
    }

    public void setPoundExpr(ValueExpression poundExpr) {
        this.poundExpr = poundExpr;
    }

    public void doTag() throws JspException, IOException {
        ELContext elContext = getJspContext().getELContext();
        JspWriter out = getJspContext().getOut();

        try {
            String poundValue = (String) poundExpr.getValue(elContext);
            if (!poundValue.equals(dollarValue)) {
                out.println("Test FAILED. Non-deferred and deferred ");
                out.println("values do not match.");
                out.println("Non-deferred value = " + dollarValue);
                out.println("Deferred value = " + poundValue); 
            }
            else {
                out.println("Test PASSED."); 
            }
        } catch (Throwable t) {
            JspTestUtil.handleThrowable(t, out, "PoundDollarSameMeaningTag");
        }
    }
}
