<%@ page import="java.io.PrintWriter,
                 com.sun.ts.tests.jsp.common.util.JspTestUtil"%>
 <%--
   Copyright 2003 - 2009 Sun Microsystems, Inc.  All rights reserved.
   SUN PROPRIETARY/CONFIDENTIAL.  Use is subject license terms.
--%>

<%@ page contentType="text/plain" %>
<%@ taglib uri="http://java.sun.com/tck/jsp/simpletagsupport" prefix="simtag" %>
<%@ taglib tagdir="/WEB-INF/tags/simpletagsupport" prefix="tagfile" %>

<%--
    Sync variables declared by TEI.
    SimpleTag instance will set page context attributes
    begin to 1 and end to 2.  This should be synchronized
    to scripting variables begin and end respectively.
--%>
<simtag:sync />
<%
    if (begin.intValue() != 1) {
        out.println("Test FAILED.  Expected begin to be '1' after tag " +
            "completion.  Actual value: " + begin);
    }
    if (end.intValue() != 2) {
        out.println("Test FAILED.  Expected end to be '2' after tag " +
            "completion.  Actual value: " + end);
    }
%>

<%--
    Sync variables declared by variable elements in TLD
    SimpleTag instance will set page context attributes
    begin to 2 and end to 3.  This should be synchronized
    to scripting variables begin and end respectively.
--%>
<simtag:sync1 />
<%
    if (begin.intValue() != 2) {
        out.println("Test FAILED.  Expected begin to be '2' after tag " +
            "completion.  Actual value: " + begin);
    }
    if (end.intValue() != 3) {
        out.println("Test FAILED.  Expected end to be '3' after tag " +
            "completion.  Actual value: " + end);
    }
%>

<%-- Sync variables declared in Tag file --%>
<%
    // If a page scoped attribute has the same name
    // as a declared NESTED variable in the tag, then
    // the calling page scoped attribute needs to be restored
    // after the invocation of the tag.  No synchronization
    // should occur.
    Integer nested = new Integer(5);
    pageContext.setAttribute("nested", nested);
%>
<tagfile:Sync />
<%
    if (begin.intValue() != 3) {
        out.println("Test FAILED.  Expected begin to be '3' after tag " +
            "completion.  Actual value: " + begin);
    }
    if (end.intValue() != 1) {
        out.println("Test FAILED.  Expected end to be '1' after tag " +
            "completion.  Actual value: " + end);
    }
    if (nested.intValue() != 5) {
        out.println("Test FAILED.  Variable synchronization incorrectly occured" +
            "for a nested variable declared by the Tag file.  The original value" +
            "of '5' should have been restored after doTag() returned.");
    }
%>
