/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public abstract class FloatQuestion
extends Question {
    protected float value = Float.NaN;
    protected float[] suggestions;
    private float defaultValue = Float.NaN;
    private String stringValue;
    private transient String newStringValue;
    private float min = Float.MIN_VALUE;
    private float max = Float.MAX_VALUE;
    private float resolution;
    private float labelStart;
    private float labelIncrement;
    private static final ResourceBundle i18n = Interview.i18n;

    protected FloatQuestion(Interview interview, String tag) {
        super(interview, tag);
        this.clear();
        this.setDefaultValue(this.value);
    }

    protected FloatQuestion(Interview interview, String tag, float min, float max, float resolution) {
        super(interview, tag);
        this.setBounds(min, max);
        this.setResolution(resolution);
        this.clear();
        this.setDefaultValue(this.value);
    }

    protected void setBounds(float min, float max) {
        if (min >= max) {
            throw new IllegalArgumentException("invalid bounds");
        }
        this.min = min;
        this.max = max;
    }

    public float getLowerBound() {
        return this.min;
    }

    public float getUpperBound() {
        return this.max;
    }

    public boolean isValid() {
        return !Float.isNaN(this.value) && (this.min == Float.MIN_VALUE || this.min <= this.value) && this.value <= this.max;
    }

    public void setResolution(float resolution) {
        this.resolution = resolution;
    }

    public float getResolution() {
        return this.resolution;
    }

    public float[] getSuggestions() {
        return this.suggestions;
    }

    public void setSuggestions(float[] newSuggestions) {
        this.suggestions = newSuggestions;
    }

    public float getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(float v) {
        this.defaultValue = v;
    }

    public float getValue() {
        return this.value;
    }

    public float getValueOnPath() throws Interview.NotOnPathFault {
        this.interview.verifyPathContains(this);
        return this.getValue();
    }

    @Override
    public String getStringValue() {
        if (this.stringValue == null) {
            if (Float.isNaN(this.value)) {
                this.stringValue = "";
            } else {
                NumberFormat fmt = NumberFormat.getNumberInstance();
                this.stringValue = fmt.format(new Double(this.value));
            }
        }
        return this.stringValue;
    }

    @Override
    public void setValue(String s) throws Interview.Fault {
        this.setValue(s, Locale.getDefault());
    }

    public void setValue(String s, Locale l) throws Interview.Fault {
        float f;
        if (s != null) {
            s = s.trim();
        }
        if (s == null || s.length() == 0 || s.equals("NaN")) {
            f = Float.NaN;
        } else {
            ParsePosition pos;
            NumberFormat fmt = NumberFormat.getNumberInstance(l);
            Number num = fmt.parse(s, pos = new ParsePosition(0));
            if (num != null && pos.getIndex() == s.length()) {
                f = num.floatValue();
                fmt = NumberFormat.getNumberInstance();
                s = fmt.format(new Double(f));
            } else {
                f = Float.NaN;
            }
        }
        this.newStringValue = s;
        this.setValue(f);
    }

    public void setValue(float newValue) {
        float oldValue = this.value;
        this.value = newValue;
        this.stringValue = this.newStringValue;
        this.newStringValue = null;
        if (Float.isNaN(this.value) ? !Float.isNaN(oldValue) : this.value != oldValue) {
            this.interview.updatePath(this);
            this.interview.setEdited(true);
        }
    }

    @Override
    public boolean isValueValid() {
        return this.isValid();
    }

    @Override
    public boolean isValueAlwaysValid() {
        return false;
    }

    protected void setLabelHints(float start, float increment) {
        this.labelStart = start;
        this.labelIncrement = increment;
    }

    public float getLabelStartHint() {
        return this.labelStart;
    }

    public float getLabelIncrementHint() {
        return this.labelIncrement;
    }

    @Override
    public void clear() {
        this.setValue(this.defaultValue);
    }

    @Override
    protected void load(Map data) {
        Object o = data.get(this.tag);
        if (o == null) {
            this.clear();
        } else if (o instanceof Float) {
            this.setValue(((Float)o).floatValue());
        } else if (o instanceof String) {
            Locale l = Interview.readLocale(data);
            try {
                this.setValue((String)o, l);
            }
            catch (Interview.Fault e) {
                throw new Error(e);
            }
        }
    }

    @Override
    protected void save(Map data) {
        data.put(this.tag, this.getStringValue());
    }
}

