/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.apiCheck;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javasoft.sqe.apiCheck.ClassProcessor;
import javasoft.sqe.apiCheck.PackageSet;

class PathWalk {
    static final int maxdepth = 64;
    PackageSet packages;
    ClassProcessor cproc;
    Vector visited = new Vector();

    PathWalk(PackageSet ps, ClassProcessor cp) {
        this.packages = ps;
        this.cproc = cp;
    }

    void Close() {
        this.packages = null;
        this.cproc = null;
    }

    boolean Walk(String path) {
        ZipFile z;
        if (path.length() == 0) {
            return false;
        }
        File f = new File(path);
        if (!f.exists()) {
            return true;
        }
        if (f.isDirectory()) {
            this.WalkDir(0, "", path, "");
            return true;
        }
        try {
            z = new ZipFile(path);
        }
        catch (IOException x) {
            System.err.println("not a zip file \"" + path + "\"");
            return false;
        }
        Enumeration<? extends ZipEntry> e = z.entries();
        while (e.hasMoreElements()) {
            this.WalkZip(z, e.nextElement());
        }
        try {
            z.close();
        }
        catch (IOException x) {
            // empty catch block
        }
        return true;
    }

    private void WalkDir(int depth, String pack, String path, String name) {
        String s = path + name;
        File f = new File(s);
        if (!f.exists()) {
            return;
        }
        if (f.isDirectory()) {
            if ((pack = pack + name).length() != 0 && !this.packages.OnPath(pack = pack + '.')) {
                return;
            }
            path = s;
            if (!path.endsWith(File.separator)) {
                path = path + File.separatorChar;
            }
            if (depth == 64) {
                System.err.println("out of stack: directory depth " + depth);
                return;
            }
            if (this.visited.contains(s)) {
                return;
            }
            this.visited.addElement(s);
            String[] ss = f.list();
            if (ss != null) {
                for (int i = 0; i < ss.length; ++i) {
                    this.WalkDir(depth + 1, pack, path, ss[i]);
                }
            }
        } else {
            this.WalkFile(pack, name, f, null);
        }
    }

    private void WalkZip(ZipFile z, ZipEntry ze) {
        if (!ze.isDirectory()) {
            String name = ze.getName();
            int i = name.lastIndexOf(47);
            if (i > 0) {
                this.WalkFile(name.substring(0, i + 1).replace('/', '.'), name.substring(i + 1), z, ze);
            } else {
                this.WalkFile("", name, z, ze);
            }
        }
    }

    void WalkFile(String pack, String name, Object src, Object sub) {
        if (pack != null && pack.length() != 0 && !pack.endsWith(".")) {
            pack = pack + '.';
        }
        if (name.endsWith(".class") && this.packages.InPath(pack)) {
            this.cproc.ProcessClass(pack, name.substring(0, name.length() - 6), src, sub);
        }
    }
}

