/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xmlimpl;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Ref;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.xmlimpl.XMLObjectImpl;

class XMLName
extends Ref {
    private String uri;
    private String localName;
    private boolean isAttributeName;
    private boolean isDescendants;

    private XMLName(String uri, String localName) {
        this.uri = uri;
        this.localName = localName;
    }

    static XMLName formStar() {
        return new XMLName(null, "*");
    }

    static XMLName formProperty(String uri, String localName) {
        return new XMLName(uri, localName);
    }

    String uri() {
        return this.uri;
    }

    String localName() {
        return this.localName;
    }

    boolean isAttributeName() {
        return this.isAttributeName;
    }

    void setAttributeName() {
        if (this.isAttributeName) {
            throw new IllegalStateException();
        }
        this.isAttributeName = true;
    }

    boolean isDescendants() {
        return this.isDescendants;
    }

    void setIsDescendants() {
        if (this.isDescendants) {
            throw new IllegalStateException();
        }
        this.isDescendants = true;
    }

    public boolean has(Context cx, Scriptable target) {
        XMLObjectImpl xmlObject = (XMLObjectImpl)target;
        if (xmlObject == null) {
            return false;
        }
        return xmlObject.hasXMLProperty(this);
    }

    public Object get(Context cx, Scriptable target) {
        XMLObjectImpl xmlObject = (XMLObjectImpl)target;
        if (xmlObject == null) {
            throw ScriptRuntime.undefReadError(Undefined.instance, this.toString());
        }
        return xmlObject.getXMLProperty(this);
    }

    public Object set(Context cx, Scriptable target, Object value) {
        XMLObjectImpl xmlObject = (XMLObjectImpl)target;
        if (xmlObject == null) {
            throw ScriptRuntime.undefWriteError(Undefined.instance, this.toString(), value);
        }
        if (this.isDescendants) {
            throw Kit.codeBug();
        }
        xmlObject.putXMLProperty(this, value);
        return value;
    }

    public boolean delete(Context cx, Scriptable target) {
        XMLObjectImpl xmlObject = (XMLObjectImpl)target;
        if (xmlObject == null) {
            return true;
        }
        xmlObject.deleteXMLProperty(this);
        return !xmlObject.hasXMLProperty(this);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        if (this.isDescendants) {
            buff.append("..");
        }
        if (this.isAttributeName) {
            buff.append('@');
        }
        if (this.uri == null) {
            buff.append('*');
            if (this.localName().equals("*")) {
                return buff.toString();
            }
        } else {
            buff.append('\"').append(this.uri()).append('\"');
        }
        buff.append(':').append(this.localName());
        return buff.toString();
    }
}

