/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.AllTestsFilter;
import com.sun.javatest.CompositeFilter;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.LastRunFilter;
import com.sun.javatest.ParameterFilter;
import com.sun.javatest.TestFilter;
import com.sun.javatest.report.Report;
import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.tool.CommandManager;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.ListIterator;

public class ReportManager
extends CommandManager {
    private static final String[] FILTERS = new String[]{"lastRun", "currentConfig", "allTests"};
    public static final String BUGRPT_URL_PREF = "exec.report.bugurl";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(ReportManager.class);

    @Override
    public HelpTree.Node getHelp() {
        HelpTree.Node[] cmdNodes = new HelpTree.Node[]{this.getCommandHelp(ReportCommand.getName()), this.getCommandHelp(WriteReportCommand.getName())};
        return new HelpTree.Node(i18n, "rm.help", cmdNodes);
    }

    private HelpTree.Node getCommandHelp(String name) {
        return new HelpTree.Node(i18n, "rm.help." + name);
    }

    @Override
    public boolean parseCommand(String cmd, ListIterator argIter, CommandContext ctx) throws Command.Fault {
        if (ReportManager.isMatch(cmd, ReportCommand.getName())) {
            ctx.addCommand(new ReportCommand(argIter));
            return true;
        }
        if (ReportManager.isMatch(cmd, WriteReportCommand.getName())) {
            ctx.addCommand(new WriteReportCommand(argIter));
            return true;
        }
        return false;
    }

    public static void writeReport(File reportDir, CommandContext ctx) throws Command.Fault {
        WriteReportCommand c = new WriteReportCommand(reportDir);
        ((Command)c).run(ctx);
    }

    private static File[] stringsToFiles(String[] tests) {
        if (tests == null) {
            return null;
        }
        File[] files = new File[tests.length];
        for (int i = 0; i < tests.length; ++i) {
            files[i] = new File(tests[i]);
        }
        return files;
    }

    static class WriteReportCommand
    extends Command {
        private File path;
        private boolean createFlag;
        private String type;
        private String filter;

        static String getName() {
            return "writeReport";
        }

        WriteReportCommand(Iterator argIter) throws Command.Fault {
            super(WriteReportCommand.getName());
            while (argIter.hasNext()) {
                String arg = this.nextArg(argIter);
                if (arg.equals("-create")) {
                    this.createFlag = true;
                    continue;
                }
                if (arg.equals("-type")) {
                    if (!argIter.hasNext()) {
                        throw new Command.Fault(this, i18n, "rm.writeReport.missingArg");
                    }
                    this.type = this.nextArg(argIter);
                    continue;
                }
                if (arg.equals("-filter")) {
                    if (!argIter.hasNext()) {
                        throw new Command.Fault(this, i18n, "rm.writeReport.missingArg");
                    }
                    this.filter = this.nextArg(argIter);
                    this.validateFilter();
                    continue;
                }
                if (arg.startsWith("-")) {
                    throw new Command.Fault((Command)this, i18n, "rm.writeReport.badArg", arg);
                }
                this.path = new File(arg);
                return;
            }
            throw new Command.Fault(this, i18n, "rm.writeReport.missingArg");
        }

        WriteReportCommand(File reportDir) {
            super(reportDir.getPath());
            this.path = reportDir;
        }

        private void validateFilter() throws Command.Fault {
            if (!StringArray.contains(FILTERS, this.filter)) {
                throw new Command.Fault((Command)this, i18n, "rm.writeReport.notAFilter", this.filter);
            }
        }

        @Override
        public boolean isActionCommand() {
            return true;
        }

        @Override
        public void run(CommandContext ctx) throws Command.Fault {
            if (this.path.exists()) {
                if (!this.path.isDirectory()) {
                    throw new Command.Fault((Command)this, i18n, "rm.writeReport.notADir", this.path);
                }
            } else {
                if (this.createFlag) {
                    this.path.mkdirs();
                } else {
                    this.path.mkdir();
                }
                if (!this.path.exists()) {
                    throw new Command.Fault((Command)this, i18n, "rm.writeReport.cantCreate", this.path);
                }
            }
            InterviewParameters p = this.getConfig(ctx);
            TestFilter filterO = null;
            if (this.filter == null || this.filter.equalsIgnoreCase("currentConfig")) {
                ParameterFilter pFilter = new ParameterFilter();
                pFilter.update(p);
                filterO = pFilter;
            } else if (this.filter.equalsIgnoreCase("allTests")) {
                filterO = new AllTestsFilter();
            } else if (this.filter.equalsIgnoreCase("lastRun")) {
                try {
                    filterO = new LastRunFilter(ctx.getWorkDirectory());
                }
                catch (CommandContext.Fault f) {
                    ctx.printMessage(i18n, "rm.writeReport.noWdForLast", f.getMessage());
                }
            } else {
                filterO = new CompositeFilter(p.getFilters());
            }
            try {
                File cPath;
                Report r = new Report(p, this.path, filterO);
                if (this.type == null) {
                    r.writeReport();
                } else {
                    r.writeReport(this.type);
                }
                try {
                    cPath = this.path.getCanonicalFile();
                }
                catch (IOException e) {
                    cPath = this.path;
                }
                ctx.printMessage(i18n, "rm.writeReport.done", cPath);
            }
            catch (IOException e) {
                ctx.printMessage(i18n, "rm.writeReport.error", new Object[]{this.path, e});
            }
        }
    }

    static class ReportCommand
    extends Command {
        private File path;

        static String getName() {
            return "report";
        }

        ReportCommand(ListIterator argIter) throws Command.Fault {
            super(ReportCommand.getName());
            if (!argIter.hasNext()) {
                throw new Command.Fault(this, i18n, "rm.report.missingArg");
            }
            this.path = new File(this.nextArg(argIter));
        }

        @Override
        public void run(CommandContext ctx) throws Command.Fault {
            ctx.setAutoRunReportDir(this.path);
        }
    }
}

