/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.SubmitMethod;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.lang.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebRequestSettings
implements Serializable {
    private static final long serialVersionUID = -7405507885099274031L;
    private URL url_;
    private String proxyHost_;
    private int proxyPort_;
    private HttpMethod httpMethod_ = HttpMethod.GET;
    private FormEncodingType encodingType_ = FormEncodingType.URL_ENCODED;
    private Map<String, String> additionalHeaders_ = new HashMap<String, String>();
    private CredentialsProvider credentialsProvider_;
    private String charset_ = "ISO-8859-1";
    private List<NameValuePair> requestParameters_ = Collections.emptyList();
    private String requestBody_;

    public WebRequestSettings(URL target) {
        this.setUrl(target);
    }

    public WebRequestSettings(WebRequestSettings originalRequest, URL target) {
        this(target);
        this.setProxyHost(originalRequest.getProxyHost());
        this.setProxyPort(originalRequest.getProxyPort());
    }

    @Deprecated
    public WebRequestSettings(URL target, SubmitMethod submitMethod) {
        this(target);
        this.setSubmitMethod(submitMethod);
    }

    public WebRequestSettings(URL target, HttpMethod submitMethod) {
        this(target);
        this.setHttpMethod(submitMethod);
    }

    @Deprecated
    public URL getURL() {
        return this.url_;
    }

    public URL getUrl() {
        return this.url_;
    }

    @Deprecated
    public void setURL(URL url) {
        this.url_ = url;
    }

    public void setUrl(URL url) {
        this.url_ = url;
    }

    public String getProxyHost() {
        return this.proxyHost_;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost_ = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort_;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort_ = proxyPort;
    }

    public FormEncodingType getEncodingType() {
        return this.encodingType_;
    }

    public void setEncodingType(FormEncodingType encodingType) {
        this.encodingType_ = encodingType;
    }

    public List<NameValuePair> getRequestParameters() {
        return this.requestParameters_;
    }

    public void setRequestParameters(List<NameValuePair> requestParameters) throws RuntimeException {
        if (this.requestBody_ != null) {
            String msg = "Trying to set the request parameters, but the request body has already been specified;the two are mutually exclusive!";
            throw new RuntimeException("Trying to set the request parameters, but the request body has already been specified;the two are mutually exclusive!");
        }
        this.requestParameters_ = requestParameters;
    }

    public String getRequestBody() {
        return this.requestBody_;
    }

    public void setRequestBody(String requestBody) throws RuntimeException {
        if (this.requestParameters_ != null && !this.requestParameters_.isEmpty()) {
            String msg = "Trying to set the request body, but the request parameters have already been specified;the two are mutually exclusive!";
            throw new RuntimeException("Trying to set the request body, but the request parameters have already been specified;the two are mutually exclusive!");
        }
        if (this.httpMethod_ != HttpMethod.POST && this.httpMethod_ != HttpMethod.PUT) {
            String msg = "The request body may only be set for POST or PUT requests!";
            throw new RuntimeException("The request body may only be set for POST or PUT requests!");
        }
        this.requestBody_ = requestBody;
    }

    @Deprecated
    public SubmitMethod getSubmitMethod() {
        return SubmitMethod.getInstance(this.httpMethod_.name());
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod_;
    }

    @Deprecated
    public void setSubmitMethod(SubmitMethod submitMethod) {
        this.setHttpMethod(HttpMethod.valueOf(submitMethod.getName().toUpperCase()));
    }

    public void setHttpMethod(HttpMethod submitMethod) {
        this.httpMethod_ = submitMethod;
    }

    public Map<String, String> getAdditionalHeaders() {
        return this.additionalHeaders_;
    }

    public void setAdditionalHeaders(Map<String, String> additionalHeaders) {
        this.additionalHeaders_ = additionalHeaders;
    }

    public void addAdditionalHeader(String name, String value) {
        this.additionalHeaders_.put(name, value);
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider_;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider_ = credentialsProvider;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(ClassUtils.getShortClassName(this.getClass()));
        buffer.append("[<");
        buffer.append("url=\"" + this.url_.toExternalForm() + "\"");
        buffer.append(", " + (Object)((Object)this.httpMethod_));
        buffer.append(", " + this.encodingType_);
        buffer.append(", " + this.requestParameters_);
        buffer.append(", " + this.additionalHeaders_);
        buffer.append(", " + this.credentialsProvider_);
        buffer.append(">]");
        return buffer.toString();
    }

    public String getCharset() {
        return this.charset_;
    }

    public void setCharset(String charset) {
        this.charset_ = charset;
    }
}

