/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
*/
package com.sun.ts.tests.securityapi.ham.rememberme.test3;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

import javax.enterprise.context.ApplicationScoped;
import javax.security.enterprise.CallerPrincipal;
import javax.security.enterprise.identitystore.CredentialValidationResult;
import javax.security.enterprise.identitystore.RememberMeIdentityStore;
import javax.security.enterprise.credential.RememberMeCredential;

@ApplicationScoped
public class TestRemembermeIdentityStore implements RememberMeIdentityStore {

    private final Map<String, CredentialValidationResult> identitiesMap = 
            new ConcurrentHashMap<String, CredentialValidationResult>();
    
    @Override
    public String generateLoginToken(CallerPrincipal callerPrincipal, Set<String> groups) {
        String token = UUID.randomUUID().toString();
        
        CredentialValidationResult validationResult = new CredentialValidationResult(callerPrincipal, groups);
        identitiesMap.put(token, validationResult);

        return token;
    }

    @Override
    public CredentialValidationResult validate(RememberMeCredential credential) {
        if (identitiesMap.containsKey(credential.getToken())) {
            return identitiesMap.get(credential.getToken());
        }

        return CredentialValidationResult.INVALID_RESULT;
    }

    @Override
    public void removeLoginToken(String token) {
       identitiesMap.remove(token);
    }
}
