/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.securityapi.idstore.noidstore;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

import javax.annotation.security.DeclareRoles;
import javax.security.enterprise.authentication.mechanism.http.AuthenticationParameters;
import javax.security.enterprise.credential.Credential;
import javax.security.enterprise.credential.Password;
import javax.security.enterprise.credential.UsernamePasswordCredential;
import javax.servlet.ServletException;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/**
 * Test Servlet that prints out the name of the authenticated caller and whether
 * this caller is in any of the roles {Administrator, Manager, Employee}
 *
 */

//@DeclareRoles({"Administrator", "Manager", "Employee"})
@WebServlet("/ServletForNoIDStore")
public class ServletForNoIDStore extends HttpServlet {   
   

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

    	 System.out.println("Inside  ServletForIDStoreMulti:doGet() ....." + "<BR>");
     	
     	
         String webName = null;
         if (request.getUserPrincipal() != null) {
         	System.out.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");             
             webName = request.getUserPrincipal().getName();
         }

         response.getWriter().write("web username: " + webName + "\n");  
    }

}
