/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.JavaTestError;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.CE_FullView;
import com.sun.javatest.exec.CE_StdView;
import com.sun.javatest.exec.CE_View;
import com.sun.javatest.exec.ContextManager;
import com.sun.javatest.exec.DetailsBrowser;
import com.sun.javatest.exec.WorkDirChooseTool;
import com.sun.javatest.tool.FileChooser;
import com.sun.javatest.tool.FileHistory;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.Debug;
import java.awt.AWTEvent;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.help.BadIDException;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelpContentViewer;
import javax.help.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class InterviewEditor
extends ToolDialog {
    public static final int DEFAULT_MODE = 0;
    public static final int FULL_MODE = 1;
    public static final int STD_MODE = 2;
    public static final int STD_TESTS_MODE = 3;
    public static final int STD_EXCLUDE_LIST_MODE = 4;
    public static final int STD_KEYWORDS_MODE = 5;
    public static final int STD_PRIOR_STATUS_MODE = 6;
    public static final int STD_ENVIRONMENT_MODE = 7;
    public static final int STD_CONCURRENCY_MODE = 8;
    public static final int STD_TIMEOUT_FACTOR_MODE = 9;
    public static final int TEMPLATE_FULL_MODE = 10;
    private Runnable afterCloseCommand;
    @Deprecated
    protected boolean templateMode = false;
    protected ContextManager contextManager = null;
    protected InterviewParameters mainConfig;
    protected InterviewParameters viewConfig;
    private FileHistory history;
    private boolean saveRequired;
    private boolean runPending;
    private static boolean debug = Debug.getBoolean(InterviewEditor.class);
    private JMenu recentConfigMenu;
    private JMenu markerMenu;
    private JMenu searchMenu;
    private JMenu viewMenu;
    private JRadioButtonMenuItem viewFullBtn;
    private JRadioButtonMenuItem viewStdBtn;
    private JCheckBoxMenuItem viewInfoCheckBox;
    private JCheckBoxMenuItem viewTagCheckBox;
    private JMenuItem viewRefreshItem;
    private JComponent body;
    private JPanel views;
    private JHelpContentViewer infoPanel;
    private CE_FullView fullView;
    private CE_StdView stdView;
    private CE_View currView;
    private Listener listener;
    private Map customRenderersMap;
    private ActionListener closeListener;
    private final List<Observer> observers = new ArrayList<Observer>();
    private DetailsBrowser detailsBrowser;
    private static final KeyStroke detailsKey = KeyStroke.getKeyStroke("shift alt D");
    protected String ext;
    static final String CONFIG_EXTENSION = ".jti";
    static final String CONFIG_HISTORY = "configHistory.jtl";
    private static final String NEW = "new";
    private static final String LOAD = "load";
    private static final String SAVE = "save";
    private static final String SAVE_AS = "saveAs";
    private static final String REVERT = "revert";
    private static final String DONE = "done";
    private static final String REFRESH = "refresh";
    private static final String DETAILS = "details";
    static final String CLOSE = "close";
    static final String MORE_INFO_PREF = "exec.config.moreInfo";
    static final String VIEW_PREF = "exec.config.view";

    public InterviewEditor(JComponent parent, UIFactory uif, InterviewParameters ip) {
        super(parent, uif, "ce", 4352);
        WorkDirectory wd = ip.getWorkDirectory();
        if (wd == null) {
            throw new IllegalArgumentException(uif.getI18NString("ce.wdNull.err"));
        }
        this.mainConfig = ip;
        try {
            this.ext = this.getExtention();
            this.viewConfig = ip.getTestSuite().createInterview();
            this.viewConfig.setWorkDirectory(ip.getWorkDirectory());
            this.history = FileHistory.getFileHistory(wd, this.getHistoryFileName());
        }
        catch (TestSuite.Fault e) {
            // empty catch block
        }
    }

    public InterviewEditor(JComponent parent, UIFactory uif, InterviewParameters ip, ContextManager cm) {
        this(parent, uif, ip);
        this.setContextManager(cm);
    }

    void setContextManager(ContextManager cm) {
        this.contextManager = cm;
    }

    ContextManager getContextManager() {
        if (this.contextManager == null) {
            try {
                this.contextManager = (ContextManager)Class.forName("com.sun.javatest.exec.ContextManager").newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.contextManager;
    }

    protected String getExtention() {
        return CONFIG_EXTENSION;
    }

    protected String getHistoryFileName() {
        return CONFIG_HISTORY;
    }

    private void setRestorer(CE_View view) {
        this.getRestorer().setRestorePolicy(1);
        this.getRestorer().setWindowKey(this.getRestorerWindowKey(view == this.fullView));
    }

    protected String getRestorerWindowKey(boolean isFullView) {
        return "confEdit.config" + (isFullView ? ".f" : ".s");
    }

    void addToHistory(File f) {
        if (this.history == null) {
            WorkDirectory wd = this.viewConfig.getWorkDirectory();
            if (wd == null) {
                return;
            }
            this.history = FileHistory.getFileHistory(wd, this.getHistoryFileName());
        }
        this.history.add(f);
    }

    private void sync() {
        try {
            InterviewEditor.copy(this.mainConfig, this.viewConfig);
        }
        catch (Interview.Fault e) {
            this.uif.showError("ce.show.error", e.getMessage());
        }
    }

    public void newConfig() {
        this.viewConfig.clear();
        this.show(1);
    }

    private void newConfigAsk() {
        if (this.askAndSave("ce.clear.warn")) {
            this.newConfig();
        }
    }

    public void edit(int mode) {
        this.sync();
        this.show(mode);
    }

    public int getFileChooserMode() {
        return 4;
    }

    public void loadConfig() {
        this.loadConfig0(false);
    }

    protected void loadConfig0(boolean ask) {
        TestSuite ts = this.viewConfig.getTestSuite();
        WorkDirChooseTool.ExecModelStub em = new WorkDirChooseTool.ExecModelStub(ts, this.contextManager);
        try {
            em.setWorkDir(this.mainConfig.getWorkDirectory(), true);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        WorkDirChooseTool fc = WorkDirChooseTool.getTool((JComponent)this.parent, this.uif, em, this.getFileChooserMode(), ts, true);
        WorkDirChooseTool.ChosenFileHandler cfh = new WorkDirChooseTool.ChosenFileHandler();
        fc.setChosenFileHandler(cfh);
        fc.doTool();
        File f = cfh.file;
        if (f != null && (!ask || this.askAndSave("ce.load.warn"))) {
            this.loadConfigFromFile(f);
            if (cfh.isEditConfig && !this.isVisible()) {
                this.edit(1);
            }
        }
    }

    private void loadConfigAsk() {
        this.loadConfig0(true);
    }

    public void loadAndEdit(File f) {
        if (f == null) {
            return;
        }
        this.loadConfigFromFile(f);
        this.notifyObservers();
        this.show(1);
    }

    private File chooseConfigFile() {
        File mainConfigFile = this.mainConfig.getFile();
        FileChooser fileChooser = this.getFileChooser();
        if (mainConfigFile != null) {
            fileChooser.setCurrentDirectory(mainConfigFile.getParentFile());
        }
        return InterviewEditor.loadConfigFile(this.getContextManager(), this.parent, this.uif, fileChooser);
    }

    public void loadConfigFromFile(File file) {
        if (file == null) {
            return;
        }
        try {
            this.viewConfig.load(file);
            if (this.currView != null && this.currView.isShowing()) {
                this.currView.load();
            }
            this.addToHistory(file);
            this.updateTitle();
            this.notifyObservers();
        }
        catch (FileNotFoundException e) {
            this.uif.showError("ce.load.cantFindFile", file);
        }
        catch (IOException e) {
            this.uif.showError("ce.load.error", new Object[]{file, e});
        }
        catch (Interview.Fault e) {
            this.uif.showError("ce.load.error", new Object[]{file, e.getMessage()});
        }
    }

    public void save() {
        this.save0();
    }

    private boolean save0() {
        return this.save0(this.viewConfig.getFile());
    }

    public void saveAs() {
        this.save0(null);
    }

    private boolean save0(File file) {
        File mainConfigFile;
        File mainConfigDir;
        if (file == null && (file = this.getSaveFile(mainConfigDir = (mainConfigFile = this.mainConfig.getFile()) == null ? null : mainConfigFile.getParentFile())) == null) {
            return false;
        }
        try {
            if (this.currView != null) {
                this.currView.save();
            }
            this.viewConfig.setFile(file);
            this.doSave(file);
            this.addToHistory(file);
            this.updateTitle();
            this.notifyObservers();
            return true;
        }
        catch (IOException e) {
            if (!file.canWrite()) {
                this.uif.showError("ce.save.cantWriteFile", file);
            } else if (e instanceof FileNotFoundException) {
                this.uif.showError("ce.save.cantFindFile", file);
            } else {
                this.uif.showError("ce.save.error", new Object[]{file, e});
            }
        }
        catch (Interview.Fault e) {
            this.uif.showError("ce.save.error", new Object[]{file, e.getMessage()});
        }
        return false;
    }

    protected void doSave(File file) throws Interview.Fault, IOException {
        this.viewConfig.save(file);
    }

    private File getSaveFile(File dir) {
        FileChooser fileChooser = this.getFileChooser();
        fileChooser.setDialogTitle(this.uif.getI18NString("ce.save.title"));
        return InterviewEditor.saveConfigFile(this.getContextManager(), this.parent, this.uif, fileChooser, dir, this.templateMode);
    }

    private FileChooser getFileChooser() {
        FileChooser fileChooser = new FileChooser(true);
        fileChooser.addChoosableExtension(this.ext, this.uif.getI18NString("ce.jtiFiles"));
        return fileChooser;
    }

    private boolean askAndSave(String question) {
        if (this.isEdited()) {
            int rc = this.uif.showYesNoCancelDialog(question);
            switch (rc) {
                case 0: {
                    this.save();
                    return true;
                }
                case 1: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public void revert() {
        if (!this.isEdited()) {
            return;
        }
        int rc = this.uif.showOKCancelDialog("ce.revert.warn");
        if (rc != 0) {
            return;
        }
        try {
            InterviewEditor.copy(this.mainConfig, this.viewConfig);
            if (this.currView != null && this.currView.isShowing()) {
                this.currView.load();
            }
            this.updateTitle();
        }
        catch (Interview.Fault e) {
            this.uif.showError("ce.revert", e.getMessage());
        }
    }

    public void setRunPending(boolean b) {
        this.runPending = b;
    }

    public boolean isRunPending() {
        return this.runPending;
    }

    public void show() {
        if (this.stdView == null) {
            this.initGUI();
        }
        this.show(0);
    }

    public void updateMenu() {
        FileHistory h = FileHistory.getFileHistory(this.viewConfig.getWorkDirectory(), this.getHistoryFileName());
        this.recentConfigMenu.setEnabled(h.getLatestEntry() != null);
    }

    public void show(int mode) {
        if (this.stdView == null) {
            this.initGUI();
        }
        this.updateTitle();
        this.updateMenu();
        switch (mode) {
            case 0: {
                this.show(this.getDefaultView());
                break;
            }
            case 1: {
                this.show(this.fullView);
                break;
            }
            case 2: {
                this.show(this.stdView);
                break;
            }
            case 3: {
                this.stdView.showTab(0);
                this.show(this.stdView);
                break;
            }
            case 4: {
                this.stdView.showTab(1);
                this.show(this.stdView);
                break;
            }
            case 5: {
                this.stdView.showTab(2);
                this.show(this.stdView);
                break;
            }
            case 6: {
                this.stdView.showTab(3);
                this.show(this.stdView);
                break;
            }
            case 7: {
                this.stdView.showTab(4);
                this.show(this.stdView);
                break;
            }
            case 8: {
                this.stdView.showTab(6);
                this.show(this.stdView);
                break;
            }
            case 9: {
                this.stdView.showTab(7);
                this.show(this.stdView);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void show(ActionListener closeListener) {
        this.closeListener = closeListener;
        this.show();
    }

    public void show(int mode, ActionListener closeListener, boolean isTemplateMode) {
        this.closeListener = closeListener;
        this.show(mode);
    }

    private void show(CE_View newView) {
        if (this.currView != null && this.currView.isShowing()) {
            this.currView.save();
        }
        this.setRestorer(newView);
        this.setView(newView);
        this.setVisible(true);
    }

    @Override
    public void setVisible(boolean isVisible) {
        super.setVisible(isVisible);
        this.notifyObserversOfVisibility(isVisible);
    }

    private void setView(CE_View newView) {
        if (newView == null) {
            throw new NullPointerException();
        }
        if (this.currView != null && this.currView == newView) {
            this.currView.load();
        }
        if (this.currView != newView) {
            Container fcr;
            FocusTraversalPolicy ftp;
            Component c;
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component fo = kfm.getPermanentFocusOwner();
            boolean focusInView = fo != null && this.currView != null && this.currView.isAncestorOf(fo);
            this.currView = newView;
            this.currView.load();
            ((CardLayout)this.views.getLayout()).show(this.views, this.currView.getName());
            if (focusInView && (c = (ftp = (fcr = this.currView.isFocusCycleRoot() ? this.currView : this.currView.getFocusCycleRootAncestor()).getFocusTraversalPolicy()).getDefaultComponent(fcr)) != null) {
                c.requestFocusInWindow();
            }
            boolean currIsFull = this.currView == this.fullView;
            this.markerMenu.setEnabled(currIsFull);
            this.searchMenu.setEnabled(currIsFull);
            (currIsFull ? this.viewFullBtn : this.viewStdBtn).setSelected(true);
            this.viewTagCheckBox.setEnabled(currIsFull);
            if (this.detailsBrowser != null) {
                this.detailsBrowser.setQuestionInfoEnabled(currIsFull);
            }
            this.updateTitle();
        }
    }

    public void close() {
        if (this.canInterruptTemplateCreation()) {
            this.doClose();
        } else {
            this.uif.showError("ce.force_close");
        }
    }

    public void doClose() {
        if (this.currView != null && !this.currView.isOKToClose()) {
            if (this.afterCloseCommand != null) {
                this.afterCloseCommand.run();
                this.afterCloseCommand = null;
            }
            return;
        }
        this.close(true);
    }

    @Override
    protected void windowClosingAction(AWTEvent e) {
        if (!this.canInterruptTemplateCreation()) {
            this.uif.showError("ce.force_close");
            return;
        }
        if (this.fullView.isVisible()) {
            this.fullView.prepareClosing();
        }
        this.doClose();
    }

    private void close(boolean checkIfEdited) {
        if (this.currView == null) {
            return;
        }
        if (!this.isShowing()) {
            return;
        }
        if (checkIfEdited && this.isEdited()) {
            int rc = this.uif.showYesNoCancelDialog("ce.close.warn");
            switch (rc) {
                case 0: {
                    if (this.save0()) break;
                    if (this.afterCloseCommand != null) {
                        this.afterCloseCommand.run();
                        this.afterCloseCommand = null;
                    }
                    return;
                }
                case 1: {
                    break;
                }
                default: {
                    if (this.afterCloseCommand != null) {
                        this.afterCloseCommand.run();
                        this.afterCloseCommand = null;
                    }
                    return;
                }
            }
        }
        this.setVisible(false);
        if (this.closeListener != null) {
            ActionEvent e = new ActionEvent(this, 1001, CLOSE);
            this.closeListener.actionPerformed(e);
            this.closeListener = null;
        }
        if (this.afterCloseCommand != null) {
            this.afterCloseCommand.run();
            this.afterCloseCommand = null;
        }
    }

    public void setCheckExcludeListListener(ActionListener l) {
        if (this.stdView == null) {
            this.initGUI();
        }
        this.stdView.setCheckExcludeListListener(l);
    }

    boolean isCurrentQuestionChanged() {
        if (this.currView != null && this.currView.isShowing()) {
            this.currView.save();
        }
        Question mq = this.mainConfig.getCurrentQuestion();
        Question vq = this.viewConfig.getCurrentQuestion();
        return !InterviewEditor.equal(mq.getTag(), vq.getTag());
    }

    boolean isEdited() {
        if (this.currView != null && this.currView.isShowing()) {
            this.currView.save();
        }
        return !InterviewEditor.equal(this.mainConfig, this.viewConfig);
    }

    public static boolean equal(InterviewParameters a, InterviewParameters b) {
        if (a == b) {
            return true;
        }
        if (a.isTemplate() != b.isTemplate()) {
            return false;
        }
        if (a.getMarkersEnabled() != b.getMarkersEnabled() || a.getMarkersFilterEnabled() != b.getMarkersFilterEnabled()) {
            return false;
        }
        Map aQuestions = a.getAllQuestions();
        Map bQuestions = b.getAllQuestions();
        TreeSet keys = new TreeSet();
        keys.addAll(aQuestions.keySet());
        keys.addAll(bQuestions.keySet());
        for (String key : keys) {
            Question aq = (Question)aQuestions.get(key);
            Question bq = (Question)bQuestions.get(key);
            if (aq == null || bq == null) {
                return false;
            }
            if (aq.equals(bq)) continue;
            String empty = "";
            boolean eq = aq.getStringValue() == null && empty.equals(bq.getStringValue()) || empty.equals(aq.getStringValue()) && bq.getStringValue() == null;
            if (eq) continue;
            return false;
        }
        Set aKeys = a.getPropertyKeys();
        Set bKeys = b.getPropertyKeys();
        if (aKeys == null || bKeys == null) {
            return aKeys == bKeys;
        }
        if (aKeys.size() != bKeys.size()) {
            return false;
        }
        for (String key : aKeys) {
            String bProp;
            if (!bKeys.contains(key)) {
                return false;
            }
            String aProp = a.retrieveProperty(key);
            if (InterviewEditor.equal(aProp, bProp = b.retrieveProperty(key))) continue;
            return false;
        }
        return true;
    }

    public void addObserver(Observer o) {
        if (o != null && !this.observers.contains(o)) {
            this.observers.add(o);
        }
    }

    public void removeObserver(Observer o) {
        if (o != null) {
            this.observers.remove(o);
        }
    }

    protected void notifyObservers() {
        for (Observer obs : this.observers) {
            obs.changed(this.viewConfig);
        }
    }

    protected void notifyObserversOfVisibility(boolean isVisible) {
        for (Observer obs : this.observers) {
            obs.changedVisibility(isVisible, this);
        }
    }

    private static boolean equal(String a, String b) {
        return a == null || b == null ? a == b : a.equals(b);
    }

    @Override
    public void dispose() {
        if (this.viewConfig != null) {
            this.viewConfig.dispose();
            this.viewConfig = null;
        }
        super.dispose();
    }

    @Override
    protected void initGUI() {
        this.setHelp("confEdit.window.csh");
        this.listener = new Listener();
        this.updateTitle();
        if (this.viewConfig.getHelpSet() != null) {
            this.infoPanel = new JHelpContentViewer(this.viewConfig.getHelpSet());
            this.infoPanel.setName("info");
            int dpi = this.uif.getDotsPerInch();
            this.infoPanel.setPreferredSize(new Dimension(4 * dpi, 3 * dpi));
            this.infoPanel.putClientProperty("helpBrokerForHelpLink", this.uif.getHelpBroker());
        }
        this.fullView = new CE_FullView(this.viewConfig, this.infoPanel, this.uif, this.listener);
        if (this.customRenderersMap != null) {
            this.fullView.setCustomRenderers(this.customRenderersMap);
        }
        this.stdView = new CE_StdView(this.viewConfig, this.infoPanel, this.uif, this.listener);
        this.stdView.setParentToolDialog(this);
        this.initMenuBar();
        this.views = this.uif.createPanel("ce.views", new CardLayout(), false);
        this.views.add((Component)this.fullView, this.fullView.getName());
        this.views.add((Component)this.stdView, this.stdView.getName());
        if (this.infoPanel == null) {
            this.viewInfoCheckBox.setEnabled(false);
            this.viewInfoCheckBox.setSelected(false);
        } else {
            Preferences p = Preferences.access();
            boolean prefMoreInfo = p.getPreference(MORE_INFO_PREF, "true").equals("true");
            this.viewInfoCheckBox.setEnabled(true);
            this.viewInfoCheckBox.setSelected(prefMoreInfo);
        }
        if (this.viewInfoCheckBox.isSelected()) {
            this.views.setBorder(null);
            JSplitPane sp = this.uif.createSplitPane(1, this.views, this.infoPanel);
            sp.setDividerLocation(this.views.getPreferredSize().width + sp.getDividerSize());
            this.body = sp;
        } else {
            this.views.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.body = this.views;
        }
        this.views.registerKeyboardAction(this.listener, DETAILS, detailsKey, 1);
        if (this.infoPanel != null) {
            this.infoPanel.registerKeyboardAction(this.listener, DETAILS, detailsKey, 1);
        }
        this.setBody(this.body);
        this.setDefaultCloseOperation(0);
    }

    protected JMenu createFileMenu() {
        String[] fileMenuItems = new String[]{SAVE, SAVE_AS, REVERT, null, NEW, LOAD, null, CLOSE};
        JMenu fileMenu = this.uif.createMenu("ce.file", fileMenuItems, this.listener);
        FileHistory h = FileHistory.getFileHistory(this.viewConfig.getWorkDirectory(), this.getHistoryFileName());
        FileHistory.Listener l = new FileHistory.Listener(h, 0, this.listener);
        this.recentConfigMenu = this.uif.createMenu("ce.history");
        this.recentConfigMenu.setEnabled(h.getLatestEntry() != null);
        this.recentConfigMenu.addMenuListener(l);
        fileMenu.insert(this.recentConfigMenu, 4);
        return fileMenu;
    }

    private void initMenuBar() {
        this.listener = new Listener();
        JMenuBar menuBar = this.uif.createMenuBar("ce.menub");
        JMenu fileMenu = this.createFileMenu();
        menuBar.add(fileMenu);
        this.markerMenu = this.fullView.getMarkerMenu();
        menuBar.add(this.markerMenu);
        this.searchMenu = this.fullView.getSearchMenu();
        menuBar.add(this.searchMenu);
        this.viewMenu = this.uif.createMenu("ce.view");
        this.viewMenu.addMenuListener(this.listener);
        ButtonGroup viewGroup = new ButtonGroup();
        this.viewFullBtn = this.uif.createRadioButtonMenuItem("ce.view", "full");
        this.viewFullBtn.setSelected(true);
        this.viewFullBtn.setActionCommand("full");
        this.viewFullBtn.addActionListener(this.listener);
        viewGroup.add(this.viewFullBtn);
        this.viewMenu.add(this.viewFullBtn);
        this.viewStdBtn = this.uif.createRadioButtonMenuItem("ce.view", "std");
        this.viewStdBtn.setActionCommand("std");
        this.viewStdBtn.addActionListener(this.listener);
        viewGroup.add(this.viewStdBtn);
        this.viewMenu.add(this.viewStdBtn);
        this.viewMenu.addSeparator();
        this.viewInfoCheckBox = this.uif.createCheckBoxMenuItem("ce.view", "info", false);
        this.viewInfoCheckBox.addChangeListener(this.listener);
        this.viewMenu.add(this.viewInfoCheckBox);
        this.viewTagCheckBox = this.uif.createCheckBoxMenuItem("ce.view", "tag", false);
        this.viewTagCheckBox.setAccelerator(KeyStroke.getKeyStroke("control T"));
        this.viewTagCheckBox.addChangeListener(this.listener);
        this.viewMenu.add(this.viewTagCheckBox);
        this.viewMenu.addSeparator();
        this.viewRefreshItem = this.uif.createMenuItem("ce.view", REFRESH, this.listener);
        this.viewRefreshItem.setAccelerator(KeyStroke.getKeyStroke("F5"));
        this.viewMenu.add(this.viewRefreshItem);
        menuBar.add(this.viewMenu);
        menuBar.add(this.uif.createHorizontalGlue("ce.pad"));
        JMenu helpMenu = this.uif.createMenu("ce.help");
        JMenuItem mainItem = this.uif.createHelpMenuItem("ce.help.main", "confEdit.window.csh");
        helpMenu.add(mainItem);
        JMenuItem fullItem = this.uif.createHelpMenuItem("ce.help.full", "confEdit.fullView.csh");
        helpMenu.add(fullItem);
        JMenuItem stdItem = this.uif.createHelpMenuItem("ce.help.std", "confEdit.stdView.csh");
        helpMenu.add(stdItem);
        menuBar.add(helpMenu);
        this.setJMenuBar(menuBar);
    }

    protected void updateTitle() {
        File f = this.viewConfig.getFile();
        this.setI18NTitle("ce.title", new Object[]{new Integer(this.currView == this.fullView ? 0 : 1), new Integer(f == null ? 0 : 1), f});
    }

    private boolean isInfoVisible() {
        return this.body instanceof JSplitPane;
    }

    private void setInfoVisible(boolean b) {
        if (this.infoPanel == null) {
            throw new IllegalStateException();
        }
        if (b == this.isInfoVisible()) {
            return;
        }
        Dimension viewsSize = this.views.getSize();
        if (viewsSize.width == 0) {
            viewsSize = this.views.getPreferredSize();
        }
        Dimension infoSize = this.infoPanel.getSize();
        if (infoSize.width == 0) {
            infoSize = this.infoPanel.getPreferredSize();
        }
        if (b) {
            this.views.setBorder(null);
            JSplitPane sp = this.uif.createSplitPane(1, this.views, this.infoPanel);
            sp.setDividerLocation(viewsSize.width + sp.getDividerSize());
            this.body = sp;
            this.showInfoForQuestion(this.viewConfig.getCurrentQuestion());
        } else {
            this.views.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.body = this.views;
        }
        this.setBody(this.body);
        if (this.isShowing()) {
            Dimension winSize = this.getSize();
            int divWidth = new JSplitPane().getDividerSize();
            int newWidth = winSize.width;
            this.setSize(newWidth += (b ? 1 : -1) * (infoSize.width + divWidth), winSize.height);
        }
    }

    private void showInfoForQuestion(Question q) {
        try {
            Map.ID id = q.getHelpID();
            if (id == null) {
                System.err.println("WARNING: no help for " + q.getKey());
            } else {
                this.infoPanel.setCurrentID(id);
            }
        }
        catch (BadIDException e) {
            System.err.println("WARNING: no help for " + q.getKey());
        }
        catch (InvalidHelpSetContextException e) {
            JavaTestError.unexpectedException(e);
        }
    }

    private CE_View getDefaultView() {
        if (this.currView != null) {
            return this.currView;
        }
        Preferences p = Preferences.access();
        String prefView = p.getPreference(VIEW_PREF, "full");
        if (prefView.equals("std")) {
            return this.stdView;
        }
        return this.fullView;
    }

    protected void perform(String cmd) {
        if (cmd.equals(NEW)) {
            this.newConfigAsk();
        } else if (cmd.equals(LOAD)) {
            this.loadConfigAsk();
        } else if (cmd.equals(SAVE)) {
            this.save();
        } else if (cmd.equals(SAVE_AS)) {
            this.saveAs();
        } else if (cmd.equals(REVERT)) {
            this.revert();
        } else if (cmd.equals("full")) {
            this.show(this.fullView);
        } else if (cmd.equals("std")) {
            this.show(this.stdView);
        } else if (cmd.equals(CLOSE)) {
            this.close();
        } else if (cmd.equals(DONE)) {
            Integer rp;
            int rc;
            if (this.currView != null && !this.currView.isOKToClose()) {
                return;
            }
            if (!this.canInterruptTemplateCreation() && !this.viewConfig.isFinishable()) {
                this.uif.showError("ce.force_close");
                return;
            }
            this.currView.save();
            if (!this.viewConfig.isFinishable() && (rc = this.uif.showOKCancelDialog("ce.okToClose", rp = new Integer(this.runPending ? 1 : 0))) != 0) {
                return;
            }
            if (this.isEdited() || this.isCurrentQuestionChanged()) {
                this.saveRequired = true;
            }
            if (this.saveRequired) {
                if (!this.save0()) {
                    return;
                }
                this.saveRequired = false;
            }
            this.close(false);
        } else if (cmd.equals(REFRESH)) {
            if (this.currView != null) {
                this.currView.refresh();
            }
        } else if (cmd.equals(DETAILS)) {
            if (this.detailsBrowser == null) {
                this.detailsBrowser = new DetailsBrowser(this.body, this.viewConfig, this.infoPanel);
                this.detailsBrowser.setQuestionInfoEnabled(this.currView == this.fullView);
            }
            this.detailsBrowser.setVisible(true);
        } else {
            throw new IllegalArgumentException(cmd);
        }
    }

    private boolean canInterruptTemplateCreation() {
        return true;
    }

    public static void copy(InterviewParameters from, InterviewParameters to) throws Interview.Fault {
        InterviewEditor.copy(from, to, true);
    }

    private static void copy(InterviewParameters from, InterviewParameters to, boolean copyFile) throws Interview.Fault {
        HashMap data = new HashMap();
        from.save(data);
        to.load(data, false);
        to.setTemplate(from.isTemplate());
        if (copyFile) {
            to.setFile(from.getFile());
        }
        if (debug) {
            Debug.println("InterviewEditor: equal(b,a) " + InterviewEditor.equal(to, from));
        }
    }

    public static File checkLoadConfigFileDefaults(ContextManager cm) {
        if (cm == null) {
            return null;
        }
        File defaultConfigLoadPath = cm.getDefaultConfigLoadPath();
        boolean allowConfigLoadOutsideDefault = cm.getAllowConfigLoadOutsideDefault();
        if (defaultConfigLoadPath == null && !allowConfigLoadOutsideDefault) {
            throw new IllegalArgumentException("Default directory not specified for load operation when allowConfigLoadOutsideDefault is false");
        }
        if (defaultConfigLoadPath != null) {
            if (!defaultConfigLoadPath.isAbsolute()) {
                throw new IllegalArgumentException("Relative paths not currently supported. The following setting is incorrect: \"" + defaultConfigLoadPath.getPath() + "\" selected for " + "load operation");
            }
            if (defaultConfigLoadPath.isFile()) {
                throw new IllegalArgumentException("Filename selected unexpectedly as a default directory: \"" + defaultConfigLoadPath.getPath() + "\" for " + "load operation");
            }
        }
        return defaultConfigLoadPath;
    }

    static File loadConfigFile(ContextManager cm, Component parent, UIFactory uif, String ext, String key) {
        FileChooser fileChooser = new FileChooser(true);
        fileChooser.addChoosableExtension(ext, uif.getI18NString("ce.jtiFiles" + key));
        return InterviewEditor.loadConfigFile(cm, parent, uif, fileChooser);
    }

    static File loadConfigFile(ContextManager cm, Component parent, UIFactory uif, FileChooser fileChooser) {
        if (cm == null) {
            return null;
        }
        File defaultConfigLoadPath = InterviewEditor.checkLoadConfigFileDefaults(cm);
        boolean allowConfigLoadOutsideDefault = cm.getAllowConfigLoadOutsideDefault();
        File file = null;
        fileChooser.setDialogTitle(uif.getI18NString("ce.load.title"));
        if (defaultConfigLoadPath != null) {
            if (!allowConfigLoadOutsideDefault) {
                if (!new File(defaultConfigLoadPath.getAbsolutePath()).canRead()) {
                    uif.showError("ce.load.defDirNotExists", defaultConfigLoadPath);
                    return null;
                }
                fileChooser.enableDirectories(false);
            } else {
                fileChooser.enableDirectories(true);
            }
            fileChooser.setCurrentDirectory(defaultConfigLoadPath);
        }
        boolean isMatch = true;
        while (file == null) {
            int rc = fileChooser.showDialog(parent, uif.getI18NString("ce.load.btn"));
            if (rc != 0) {
                return null;
            }
            file = fileChooser.getSelectedFile();
            if (allowConfigLoadOutsideDefault) continue;
            if (defaultConfigLoadPath == null) {
                return null;
            }
            File f = new File(file.getAbsolutePath().substring(0, file.getAbsolutePath().lastIndexOf(File.separator)));
            try {
                isMatch = f.getCanonicalPath().indexOf(defaultConfigLoadPath.getCanonicalPath()) == 0;
            }
            catch (IOException ioe) {
                ioe.printStackTrace(System.err);
                return null;
            }
            if (isMatch) continue;
            uif.showError("ce.load.notAllowedDir", defaultConfigLoadPath);
            file = null;
            fileChooser.setCurrentDirectory(defaultConfigLoadPath);
        }
        if (file != null) {
            String path = file.getPath();
            String ext = fileChooser.getChosenExtension();
            if (ext == null) {
                ext = CONFIG_EXTENSION;
            }
            if (!path.endsWith(ext)) {
                file = new File(path + ext);
            }
        }
        return file;
    }

    static File saveConfigFile(ContextManager cm, Component parent, UIFactory uif, FileChooser fileChooser, File dir, boolean isTemplate) {
        if (cm == null) {
            return null;
        }
        File defaultSavePath = isTemplate ? cm.getDefaultTemplateSavePath() : cm.getDefaultConfigSavePath();
        boolean allowSaveOutsideDefault = isTemplate ? cm.getAllowTemplateSaveOutsideDefault() : cm.getAllowConfigSaveOutsideDefault();
        if (defaultSavePath == null && !allowSaveOutsideDefault) {
            throw new IllegalArgumentException("Default directory not specified for save operation when allowConfigSaveOutsideDefault is false");
        }
        if (defaultSavePath != null) {
            if (!defaultSavePath.isAbsolute()) {
                throw new IllegalArgumentException("Relative paths not currently supported. The following setting is incorrect: \"" + defaultSavePath.getPath() + "\" selected for " + "save operation");
            }
            if (defaultSavePath.isFile()) {
                throw new IllegalArgumentException("Filename selected unexpectedly as a default directory: \"" + defaultSavePath.getPath() + "\" for " + "save operation");
            }
            if (!allowSaveOutsideDefault) {
                if (!defaultSavePath.canWrite()) {
                    uif.showError("ce.save.defDirNotExists", defaultSavePath);
                    return null;
                }
                fileChooser.enableDirectories(false);
            } else {
                fileChooser.enableDirectories(true);
            }
            fileChooser.setCurrentDirectory(defaultSavePath);
        } else if (dir != null) {
            fileChooser.setCurrentDirectory(dir);
        }
        File file = null;
        boolean isMatch = true;
        while (file == null) {
            int rc = fileChooser.showDialog(parent, uif.getI18NString("ce.save.btn"));
            if (rc != 0) {
                return null;
            }
            file = fileChooser.getSelectedFile();
            if (file == null) continue;
            File f = new File(file.getAbsolutePath().substring(0, file.getAbsolutePath().lastIndexOf(File.separator)));
            if (!allowSaveOutsideDefault) {
                if (defaultSavePath == null) {
                    return null;
                }
                try {
                    isMatch = defaultSavePath.getCanonicalPath().equals(f.getCanonicalPath());
                }
                catch (IOException ioe) {
                    ioe.printStackTrace(System.err);
                    return null;
                }
                if (!isMatch) {
                    uif.showError("ce.save.notAllowedDir", defaultSavePath);
                    file = null;
                    fileChooser.setCurrentDirectory(defaultSavePath);
                    continue;
                }
            }
            if (file.isDirectory()) {
                uif.showError("ce.save.fileIsDir", file);
                file = null;
                continue;
            }
            File parentFile = file.getParentFile();
            if (parentFile != null) {
                if (parentFile.exists() && !parentFile.isDirectory()) {
                    uif.showError("ce.save.parentNotADir", parentFile);
                    file = null;
                    continue;
                }
                if (!parentFile.exists()) {
                    rc = uif.showYesNoDialog("ce.save.createParentDir", parentFile);
                    if (rc == 0) {
                        if (!parentFile.mkdirs()) {
                            uif.showError("ce.save.cantCreateParentDir", parentFile);
                            file = null;
                            continue;
                        }
                    } else {
                        file = null;
                        continue;
                    }
                }
            }
            if (!file.exists()) {
                String path = file.getPath();
                String ext = fileChooser.getChosenExtension();
                if (ext != null && !path.endsWith(ext)) {
                    file = new File(path + ext);
                }
            }
            if (file.exists()) {
                rc = uif.showYesNoDialog("ce.save.warn");
                switch (rc) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        fileChooser.setSelectedFile(null);
                        file = null;
                        break;
                    }
                }
            }
        }
        return file;
    }

    void setAfterCloseCommand(Runnable runnable) {
        this.afterCloseCommand = runnable;
    }

    public void setCustomRenderers(Map renderersMap) {
        this.customRenderersMap = renderersMap;
        if (this.fullView != null) {
            this.fullView.setCustomRenderers(this.customRenderersMap);
        }
    }

    public static interface Observer {
        public void changed(InterviewParameters var1);

        public void changedVisibility(boolean var1, InterviewEditor var2);
    }

    private class Listener
    implements ActionListener,
    ChangeListener,
    MenuListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem mi;
            File f;
            Object src = e.getSource();
            if (src instanceof JMenuItem && (f = (File)(mi = (JMenuItem)src).getClientProperty("file")) != null && InterviewEditor.this.askAndSave("ce.load.warn")) {
                InterviewEditor.this.loadConfigFromFile(f);
                return;
            }
            InterviewEditor.this.perform(e.getActionCommand());
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object src = e.getSource();
            if (src == InterviewEditor.this.viewInfoCheckBox && InterviewEditor.this.infoPanel != null) {
                InterviewEditor.this.setInfoVisible(InterviewEditor.this.viewInfoCheckBox.isSelected());
            } else if (src == InterviewEditor.this.viewTagCheckBox) {
                InterviewEditor.this.fullView.setTagVisible(InterviewEditor.this.viewTagCheckBox.isSelected());
            }
        }

        @Override
        public void menuSelected(MenuEvent e) {
            Object src = e.getSource();
            if (src == InterviewEditor.this.viewMenu) {
                InterviewEditor.this.viewTagCheckBox.setSelected(InterviewEditor.this.fullView.isTagVisible());
            }
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }
    }
}

