/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id:$
 */
package com.sun.ts.tests.servlet.api.javax_servlet.asyncevent;

import com.sun.ts.tests.servlet.common.servlets.GenericTCKServlet;
import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;

public class AsyncTestServlet extends GenericTCKServlet {

    public void constructorTest1(ServletRequest request,
            ServletResponse response) throws IOException {
        AsyncContext ac = request.startAsync();
        AsyncEvent ae = new AsyncEvent(ac);
        if (ae == null) {
            response.getWriter().println("The constructor for AsyncEvent(AsyncContext) returned a null. Test FAILED");
        } else {
            response.getWriter().println("Test PASSED");
        }
        ac.complete();
    }

    public void constructorTest2(ServletRequest request,
            ServletResponse response) throws IOException {
        AsyncContext ac = request.startAsync();
        AsyncEvent ae = new AsyncEvent(ac, request, response);
        if (ae == null) {
            response.getWriter().println("The constructor for AsyncEvent(AsyncContext, ServletRequest, ServletResponse) returned a null. Test FAILED");
        } else {
            response.getWriter().println("Test PASSED");
        }
        ac.complete();
    }

    public void constructorTest3(ServletRequest request,
            ServletResponse response) throws IOException {
        AsyncContext ac = request.startAsync();
        AsyncEvent ae = new AsyncEvent(ac, new IOException("AsyncEvent"));
        if (ae == null) {
            response.getWriter().println("The constructor for AsyncEvent(AsyncContext, Throwable) returned a null. Test FAILED");
        } else {
            response.getWriter().println("Test PASSED");
        }
        ac.complete();
    }

    public void constructorTest4(ServletRequest request,
            ServletResponse response) throws IOException {
        AsyncContext ac = request.startAsync();
        AsyncEvent ae = new AsyncEvent(ac, request, response, new IOException("AsyncEvent"));
        if (ae == null) {
            response.getWriter().println("The constructor for AsyncEvent(AsyncContext, Throwable) returned a null. Test FAILED");
        } else {
            response.getWriter().println("Test PASSED");
        }
        ac.complete();
    }

    public void getSuppliedRequestTest1(ServletRequest request,
            ServletResponse response) throws IOException {
        AsyncContext ac = request.startAsync();
        AsyncEvent ae = new AsyncEvent(ac, request, response);
        if (request != ae.getSuppliedRequest()) {
            response.getWriter().println("getSuppliedRequest() returned are incorrect. Test FAILED");
        } else {
            response.getWriter().println("Test PASSED");
        }
        ac.complete();
    }

    public void getSuppliedRequestTest2(ServletRequest request,
            ServletResponse response) throws IOException {
        AsyncContext ac = request.startAsync();
        AsyncEvent ae = new AsyncEvent(ac, request, response, new IOException("AsyncEvent"));
        if (request != ae.getSuppliedRequest()) {
            response.getWriter().println("getSuppliedRequest() returned are incorrect. Test FAILED");
        } else {
            response.getWriter().println("Test PASSED");
        }
        ac.complete();
    }


    public void getSuppliedResponseTest1(ServletRequest request,
            ServletResponse response) throws IOException {
        AsyncContext ac = request.startAsync();
        AsyncEvent ae = new AsyncEvent(ac, request, response);
        if (response != ae.getSuppliedResponse()) {
            response.getWriter().println("getSuppliedResponse() returned are incorrect. Test FAILED");
        } else {
            response.getWriter().println("Test PASSED");
        }
        ac.complete();
    }

    public void getSuppliedResponseTest2(ServletRequest request,
            ServletResponse response) throws IOException {
        AsyncContext ac = request.startAsync();
        AsyncEvent ae = new AsyncEvent(ac, request, response, new IOException("AsyncEvent"));
        if (response != ae.getSuppliedResponse()) {
            response.getWriter().println("getSuppliedResponse() returned are incorrect. Test FAILED");
        } else {
            response.getWriter().println("Test PASSED");
        }
        ac.complete();
    }

    public void getThrowableTest(ServletRequest request,
            ServletResponse response) throws IOException {
        AsyncContext ac = request.startAsync();
        IOException ie = new IOException("AsyncEvent");
        AsyncEvent ae = new AsyncEvent(ac, request, response, ie);
        if (ie != ae.getThrowable()) {
            response.getWriter().println("getThrowable() returned are incorrect. Test FAILED");
        } else {
            response.getWriter().println("Test PASSED");
        }
        ac.complete();
    }
}


