/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: WrapResponseFilter.java 63068 2011-06-15 13:57:20Z djiao $
 */

package com.sun.ts.tests.servlet.api.javax_servlet.dofilter;


import com.sun.ts.tests.servlet.common.util.ServletTestUtil;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import java.io.IOException;
import java.io.PrintWriter;


public final class WrapResponseFilter implements Filter {


    // The filter configuration object we are associated with.  If this value
    // is null, this filter instance is not currently configured.
    private FilterConfig filterConfig = null;


    public void doFilter(ServletRequest request, ServletResponse response,
                         FilterChain chain) throws IOException, ServletException {

        PrintWriter pw = response.getWriter();

        CTSResponseWrapper wrappedResponse = new CTSResponseWrapper(response);
        ServletTestUtil.printResult(pw, "in WrapResponseFilter");

        chain.doFilter(request, wrappedResponse);  
    }


    // Remove the filter configuration object for this filter.
    public void destroy() {
        this.filterConfig = null;
    }


    //  initialize the filter configuration object for this filter.

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

}

