/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: SCAttributeEventListener.java 62571 2011-04-18 20:58:13Z kgrucci $
 */

package com.sun.ts.tests.servlet.api.javax_servlet.scattributeevent;


import com.sun.ts.tests.servlet.common.util.StaticLog;

import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;

public final class SCAttributeEventListener
    implements ServletContextAttributeListener {


    // Public Methods

    public void attributeAdded(ServletContextAttributeEvent event) {
        StaticLog.add("AttributeAdded:" + event.getName() + "," + event.getValue());
    }


    public void attributeRemoved(ServletContextAttributeEvent event) {
        StaticLog.add("AttributeRemoved:" + event.getName() + "," + event.getValue());
    }


    public void attributeReplaced(ServletContextAttributeEvent event) {
        StaticLog.add("AttributeReplaced:" + event.getName() + "," + event.getValue());
    }
}
