/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */
package com.sun.ts.tests.servlet.pluggability.aordering2;

import java.io.PrintWriter;
import com.sun.javatest.Status;
import com.sun.ts.tests.servlet.common.client.AbstractUrlClient;

public class URLClient extends AbstractUrlClient {

    /**
     * Entry point for different-VM execution.  It should delegate to method
     * run(String[], PrintWriter, PrintWriter), and this method should not
     * contain any test configuration.
     */
    public static void main(String[] args) {
        URLClient theTests = new URLClient();
        Status s = theTests.run(args, new PrintWriter(System.out),
                new PrintWriter(System.err));
        s.exit();
    }

    /**
     * Entry point for same-VM execution. In different-VM execution, the
     * main method delegates to this method.
     */
    public Status run(String[] args, PrintWriter out, PrintWriter err) {
        setContextRoot("/servlet_spec_aordering2_web");
        return super.run(args, out, err);
    }

    /*
     * @class.setup_props: webServerHost;
     *                     webServerPort;
     *                     ts_home;
     */
    /*
     * @testName: absoluteOrderingTest
     *
     * @assertion_ids: Servlet:SPEC:230; Servlet:SPEC:231; Servlet:SPEC:232;
     *                 Servlet:SPEC:233; Servlet:SPEC:235;
     *
     * @test_Strategy: 1. Define seven RequestListeners and two servlets,
     *                    in web.xml and seven web-fragment.xml:
     *                    web.xml   - define and package TestServlet1, RequestListener,
     *                    with absolute-ordering of six fragments:
     *                        fragment1 - define and package TestServlet1, RequestListener1,
     *                        fragment2 - define and package RequestListener2
     *                        fragment3 - define and package RequestListener3,
     *                        fragment4 - define and package RequestListener4,
     *                        fragment5 - define and package RequestListener5,
     *                 2. fragment6 (no <name>) defines and packages  TestServlet2, RequestListener6
     *                 3. Send request to TestServlet1
     *                 4. Verify that web.xml is always processed first;
     *                 5. Verify that <absolute-ordering> works accordingly:
     *                 6. Verify that fragment6 with no <name>, is ignored.
     */
    public void absoluteOrderingTest() throws Fault {
        TEST_PROPS.setProperty(SEARCH_STRING, "msg1=first|msg2=second|" +
                "RequestListener|RequestListener1|" +
                "RequestListener2|RequestListener3|" +
                "RequestListener4|RequestListener5");
        TEST_PROPS.setProperty(UNEXPECTED_RESPONSE_MATCH,
                "RequestListener6|TestServlet2");
        TEST_PROPS.setProperty(REQUEST, "GET " + getContextRoot() +
                "/TestServlet1" + " HTTP/1.1");
        invoke();

        TEST_PROPS.setProperty(STATUS_CODE, NOT_FOUND);
        TEST_PROPS.setProperty(REQUEST, "GET " + getContextRoot() +
                "/TestServlet2" + " HTTP/1.1");
        invoke();
    }
}
