/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id:$
 */
package com.sun.ts.tests.servlet.spec.annotationservlet.webfilter;

import com.sun.ts.tests.servlet.common.servlets.GenericTCKServlet;
import com.sun.ts.tests.servlet.common.util.ServletTestUtil;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;


public class TestServlet extends GenericTCKServlet {

    public void forward1(ServletRequest request,
            ServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();

        String path = "/Servlet1";
        RequestDispatcher rd = getServletContext().getRequestDispatcher(path);

        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            request.setAttribute("from", "TestServlet");
            rd.forward(request, response);
        }
    }

    public void include1(ServletRequest request,
            ServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();

        String path = "/Servlet1";
        RequestDispatcher rd = getServletContext().getRequestDispatcher(path);

        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            request.setAttribute("from", "TestServlet");
            rd.include(request, response);
        }
        ServletTestUtil.printResult(pw, true);
    }
}
