/*
 * Copyright (c) 2009, 2015, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id:$
 */
package com.sun.ts.tests.servlet.spec.annotationservlet.weblistener;

import java.io.PrintWriter;
import com.sun.ts.tests.servlet.common.client.AbstractUrlClient;
import com.sun.javatest.Status;

public class URLClient extends AbstractUrlClient {

    /**
     * Entry point for different-VM execution.  It should delegate to method
     * run(String[], PrintWriter, PrintWriter), and this method should not
     * contain any test configuration.
     */
    public static void main(String[] args) {
        URLClient theTests = new URLClient();
        Status s = theTests.run(args, new PrintWriter(System.out),
                new PrintWriter(System.err));
        s.exit();
    }

    /**
     * Entry point for same-VM execution. In different-VM execution, the
     * main method delegates to this method.
     */
    public Status run(String args[], PrintWriter out, PrintWriter err) {
        setServletName("TestServlet");
        setContextRoot("/servlet_annotationservlet_weblistener_web");

        return super.run(args, out, err);
    }

    /*
     * @class.setup_props: webServerHost;
     *                     webServerPort;
     *                     ts_home;
     */

    /* Run test */

    /*
     * @testName: ContextListenerTest
     *
     * @assertion_ids: Servlet:JAVADOC:865; Servlet:SPEC:195.3;
     *
     * @test_Strategy: Create a servlet TestServlet;
     *                 Create a ServletContextListener using @WebListener;
     *                 Send request to TestServlet;
     *                 Veriy ServletContextListener is invoked properly.
     */
    public void ContextListenerTest() throws Fault {
        TEST_PROPS.setProperty(APITEST, "ContextListenerTest");
        TEST_PROPS.setProperty(SEARCH_STRING, "ContextInitialized");
        invoke();
    }


    /*
     * @testName: ContextAttributeListenerTest
     *
     * @assertion_ids: Servlet:JAVADOC:865; Servlet:SPEC:195.4;
     *
     * @test_Strategy: Create a servlet TestServlet;
     *                 Create a ServletContextAttributeListener using @WebListener;
     *                 Send request to TestServlet;
     *                 Veriy ServletContextAttributeListener is invoked properly.
     */
    public void ContextAttributeListenerTest() throws Fault {
        TEST_PROPS.setProperty(APITEST, "ContextAttributeListenerTest");
        TEST_PROPS.setProperty(SEARCH_STRING, "SCAAdded:ContextListener|" +
                "ContextInitialized|" +
                "SCAAdded:SRList|" +
                "in requestInitialized method of listener|" +
                "SCAAdded:Test,tmp|" +
                "SCARemoved:Test,tmp");
        invoke();
    }

    /*
     * @testName: RequsetListenerTest
     *
     * @assertion_ids: Servlet:JAVADOC:865; Servlet:SPEC:195.5;
     *
     * @test_Strategy: Create a servlet TestServlet;
     *                 Create a ServletRequestListener using @WebListener;
     *                 Send request to TestServlet;
     *                 Veriy ServletRequestListener is invoked properly.
     */
    public void RequsetListenerTest() throws Fault {
        TEST_PROPS.setProperty(APITEST, "RequsetListenerTest");
        TEST_PROPS.setProperty(SEARCH_STRING,
                "in requestInitialized method of listener");
        invoke();
    }

    /*
     * @testName: RepeatRequsetListenerTest
     *
     * @assertion_ids: Servlet:JAVADOC:865; Servlet:SPEC:195.5;
     *
     * @test_Strategy: Create a servlet TestServlet;
     *                 Create a ServletRequestListener using @WebListener;
     *                 Send request to TestServlet;
     *                 Send a second request to TestServlet;
     *                 Veriy ServletRequestListener is invoked properly.
     */
    public void RepeatRequsetListenerTest() throws Fault {
        TEST_PROPS.setProperty(APITEST, "RepeatRequsetListenerTest");
        TEST_PROPS.setProperty(SEARCH_STRING,
                "in requestInitialized method of listener");
        invoke();

        TEST_PROPS.setProperty(APITEST, "RequsetListenerTest");
        TEST_PROPS.setProperty(SEARCH_STRING,
                "in requestInitialized method of listener|" +
                "in requestDestroyed method of listener|" +
                "in requestInitialized method of listener");
        invoke();
    }

    /*
     * @testName: RequsetAttributeListenerTest
     *
     * @assertion_ids: Servlet:JAVADOC:865; Servlet:SPEC:195.6;
     *
     * @test_Strategy: Create a servlet TestServlet;
     *                 Create a ServletRequestListener using @WebListener;
     *                 Send request to TestServlet;
     *                 Veriy ServletRequestListener is invoked properly.
     */
    public void RequsetAttributeListenerTest() throws Fault {
        TEST_PROPS.setProperty(APITEST, "RequsetAttributeListenerTest");
        TEST_PROPS.setProperty(SEARCH_STRING,
                "SRAAdded:Test,RequestAttribute|" +
                "SRARemoved:Test,RequestAttribute");
        invoke();
    }

    /*
     * @testName: HttpSessionListenerTest
     *
     * @assertion_ids: Servlet:JAVADOC:865; Servlet:SPEC:195.7;
     *
     * @test_Strategy: Create a servlet HttpTestServlet;
     *                 Create a HttpSessionListener using @WebListener;
     *                 Send request to HttpTestServlet;
     *                 Create a HttpSession and then invlalidate it;
     *                 Veriy HttpSessionListener is invoked properly.
     */
    public void HttpSessionListenerTest() throws Fault {
        setServletName("HttpTestServlet");
        TEST_PROPS.setProperty(APITEST, "HttpSessionListenerTest");
        TEST_PROPS.setProperty(SEARCH_STRING,
                "HSListener:sessionCreated|" +
                "HSListener:sessionDestroyed");
        invoke();
    }


    /*
     * @testName: HttpSessionAttributeListenerTest
     *
     * @assertion_ids: Servlet:JAVADOC:865; Servlet:SPEC:289; Servlet:SPEC:195.8;
     *
     * @test_Strategy: Create a servlet TestServlet;
     *                 Create a HttpSessionAttributeListener using @WebListener;
     *                 Send request to TestServlet, that will set some attributes in;
     *                 its first call to HttpSessionAttributeListenerPreLude then once;
     *                 in this servlet method, the attributes are added, replaced, and;
     *                 removed.  This should cause the HttpSessionAttributeListener;
     *                 event to get triggered for all 3 methods.  Verification of;
     *                 the 3 triggered event methods is then checked in the 2nd;
     *                 invocation to HttpSessionAttributeListenerTest below.
     */
    public void HttpSessionAttributeListenerTest() throws Fault {

        // first invocation is to do some session attribute manipulations
        // which should trigger HttpSessionAttributeListener notifications
        TEST_PROPS.setProperty(APITEST, "HttpSessionAttributeListenerPreLude");
        TEST_PROPS.setProperty(SEARCH_STRING,"in HttpSessionAttributeListenerPreLude");
        invoke();

        // 2nd invocation checks that the HttpSessionAttributeListener notifications
        // occurred by verifying certain strings were written to HSAList attribute
        TEST_PROPS.setProperty(APITEST, "HttpSessionAttributeListenerTest");
        TEST_PROPS.setProperty(SEARCH_STRING,
                "HSAttributeListener.attributeAdded|" +
                "HSAttributeListener.attributeReplaced|" +
                "HSAttributeListener.attributeRemoved");
        invoke();

    }

}
