/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */

package com.sun.ts.tests.servlet.spec.listenerorder;

import javax.servlet.*;

public class ServletRequestListener1 implements ServletRequestListener {

    public void requestInitialized(ServletRequestEvent sre) {
        ServletRequest sr = sre.getServletRequest();
        if (sr.getAttribute("name_2") != null) {
            throw new IllegalStateException(
                "Unexpected request attribute name_2 during requestInitialized");
        }
        if (sr.getAttribute("name_3") != null) {
            throw new IllegalStateException(
                "Unexpected request attribute name_3 during requestInitialized");
        }
        sr.setAttribute("name_1", "value_1");
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        ServletRequest sr = sre.getServletRequest();
        if (sr.getAttribute("name_2") != null) {
            throw new IllegalStateException(
                "Unexpected request attribute name_2 during requestDestroyed");
        }
        if (sr.getAttribute("name_3") != null) {
            throw new IllegalStateException(
                "Unexpected request attribute name_3 during requestDestroyed");
        }
        sr.removeAttribute("name_1");
    }
}

