/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */

package com.sun.ts.tests.servlet.spec.multifiltermapping;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import java.io.IOException;
import java.io.PrintWriter;


public final class Test_IncludeFilter implements Filter {

    // The filter configuration object we are associated with.  If this value
    // is null, this filter instance is not currently configured.
    private FilterConfig filterConfig = null;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        PrintWriter pw = response.getWriter();
        pw.println("in Test_IncludeFilter");
        chain.doFilter(request, response);
    }

    // Remove the filter configuration object for this filter.
    public void destroy() {
    }

    //  initialize the filter configuration object for this filter.
    public void init(FilterConfig filterConfig) throws ServletException {
        if ( filterConfig == null ) {
            throw new ServletException("Failed to initialize the filter configuration");
        } else {
            this.filterConfig = filterConfig;
        }
    }
}

