/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: WrapServlet.java 62571 2011-04-18 20:58:13Z kgrucci $
 */

/*
 * $URL: https://adc4110351.us.oracle.com/svn/spider/branches/cts/8.0/src/com/sun/ts/tests/servlet/spec/requestdispatcher/WrapServlet.java $ $LastChangedDate: 2011-04-18 13:58:13 -0700 (Mon, 18 Apr 2011) $
 */
 
package com.sun.ts.tests.servlet.spec.requestdispatcher;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

public class WrapServlet extends HttpServlet {

    ServletContext ctx = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        System.out.println("WRAP INIT...");
        ctx = servletConfig.getServletContext();
    }

    public void service(HttpServletRequest request, HttpServletResponse response)
        throws ServletException, IOException {
        System.out.println("IN WRAP SERVLET...");
        Object ctxRequest = ctx.getAttribute("tck.request");
        Object ctxResponse = ctx.getAttribute("tck.response");
        ctx.removeAttribute("tck.request");
        ctx.removeAttribute("tck.response");

        PrintWriter pw = response.getWriter();
        pw.println("In Wrap servlet...");
        if (ctxRequest != null && ctxResponse != null) {
            if (ctxRequest == request) {
                if (ctxResponse == response) {
                    pw.println("Test PASSED");
                } else {
                    pw.println("Test FAILED.  Expected the response object passed to" +
                        " the target of a RequestDispatcher operation to be the same that" +
                        " was passed to the RequestDispatcher.");
                    pw.println("Original response: " + ctxResponse);
                    pw.println("Passed responset: " + response);
                }
            } else {
                pw.println("Test FAILED.  Expected the request object passed to" +
                    " the target of a RequestDispatcher operation to be the same that" +
                    " was passed to the RequestDispatcher.");
                pw.println("Original request: " + ctxRequest);
                pw.println("Passed request: " + request);
            }
        } else {
            pw.println("Test FAILED. Unable to find all required ServletContext values.");
            pw.println("tck.request: " + ctxRequest);
            pw.println("tck.response: " + ctxResponse);
        }
    }
}
