/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: UnProtectedTestServlet.java 52684 2007-02-12 04:30:10Z lschwenk $
 */

package com.sun.ts.tests.servlet.spec.security.annotations;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.annotation.WebServlet;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.ServletSecurity.*;


/*
 * this sets PERMITALL on everything.
 */

@ServletSecurity
@WebServlet("/UnProtectedTest")
public class UnProtectedTestServlet extends HttpServlet {

    public void doGet(HttpServletRequest request, 
                      HttpServletResponse response) 
           throws ServletException, IOException {

        PrintWriter out = response.getWriter();
        if ((request != null) && (request.getUserPrincipal() == null)) {
            out.println("The user principal is: " + request.getUserPrincipal() + "<BR>");
        } else {
            out.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");
        }

        if ((request != null) && (request.getUserPrincipal() != null)) {
            // Output whether the user is in any of the known or an unknown role.
            // Surround these with !'s so they are easier to search for.
            // (i.e. we can search for !true! or !false!)
            out.println("isUserInRole(\"ADM\"): !" + request.isUserInRole("ADM") + "!<BR>");
            out.println("isUserInRole(\"MGR\"): !" + request.isUserInRole("MGR") + "!<BR>");
            out.println("isUserInRole(\"EMP\"): !" + request.isUserInRole("EMP") + "!<BR>");
        } 

        if (request != null) {
            // Test getRemoteUser() functionality:
            out.println("<BR>");
            out.println("getRemoteUser(): " + request.getRemoteUser());
        } else {
            out.println("UnProtectedTestServlet.service() has null request");
        }
    }
}

