/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */


package com.sun.ts.tests.servlet.spec.security.metadatacomplete;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.annotation.WebServlet;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.ServletSecurity.*;
import javax.servlet.annotation.HttpConstraint;



/*
 * This annotation essentially sets Deny all access on the servlet.  However, our
 * DD is set with metadata-complete=true so the DD will cause any annotations
 * in this servlet to be ignored and the DD settings currently leave the 
 * servlet unprotected so a Permit all should ultmiately be set on this servlet.
 */
@ServletSecurity(@HttpConstraint(EmptyRoleSemantic.DENY))
@WebServlet(name="UnProtectedTestLogicalName", urlPatterns={"/UnProtectedTest"})
public class UnProtectedTestServlet extends HttpServlet {

    public void doGet(HttpServletRequest request, 
                      HttpServletResponse response) 
           throws ServletException, IOException {

        PrintWriter out = response.getWriter();
        if ((request != null) && (request.getUserPrincipal() == null)) {
            out.println("The user principal is: " + request.getUserPrincipal() + "<BR>");
        } else {
            out.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");
        }
    }
}

