/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: HttpTestServlet.java 51063 2006-08-11 19:56:36Z lschwenk $
 */

/*
 * %E% %E%
 */

package com.sun.ts.tests.servlet.spec.servletresponse;


import com.sun.ts.tests.servlet.common.servlets.HttpTCKServlet;

import javax.servlet.http.HttpServlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;


public class HttpTestServlet extends HttpServlet {

    public void service(HttpServletRequest request, HttpServletResponse response)
        throws ServletException, IOException {
        
        response.setContentType("text/plain");
        PrintWriter pw = response.getWriter();

        pw.write("flushBufferTest for compatibility\n\r");
        System.out.println("flushBufferTest for compatibility");
        response.flushBuffer();
        
        try {
            Thread.sleep(10000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

        //write the second part of the document and flush by exit method
        pw.write("Test Failed\n\r");
    }
    
    public void doGet(HttpServletRequest request, HttpServletResponse response)
        throws ServletException, IOException {
        service(request,response);
    }
    
     public void doPost(HttpServletRequest request, HttpServletResponse response)
        throws ServletException, IOException {
        service(request,response);
    }
}
