/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */

package com.sun.ts.tests.servlet.spec.servletresponse;

import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import java.io.IOException;
import java.io.PrintWriter;


public class TestServlet extends GenericServlet {

    public void service(ServletRequest request, ServletResponse response)
        throws ServletException, IOException {
        
        response.setContentType("text/plain");
        PrintWriter pw = response.getWriter();

        pw.write("flushBufferTest for compatibility\n\r");
        System.out.println("flushBufferTest for compatibility");
        response.flushBuffer();
        
        try {
            Thread.sleep(10000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

        //write the second part of the document and flush by exit method
        pw.write("Test Failed\n\r");
    }
    
    public void doGet(ServletRequest request, ServletResponse response)
        throws ServletException, IOException {
        service(request,response);
    }
    
     public void doPost(ServletRequest request, ServletResponse response)
        throws ServletException, IOException {
        service(request,response);
    }
}
