/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: BinaryAndTextClientEndpoint.java 72627 2013-08-20 13:33:05Z supol $
 */

package com.sun.ts.tests.websocket.common.client;

import java.nio.ByteBuffer;

import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.util.IOUtil;

/**
 * Receive any of ByteBuffer (binary) and String (Text) messages, the client
 * behaves without making any difference on type of message received.
 */
public class BinaryAndTextClientEndpoint extends ClientEndpoint<String> {
	@Override
	public void onOpen(Session session, EndpointConfig config) {
		super.onOpen(session, config);
		session.addMessageHandler(new MessageHandler.Whole<ByteBuffer>() {
			@Override
			public void onMessage(ByteBuffer message) {
				String msg = IOUtil.byteBufferToString(message);
				BinaryAndTextClientEndpoint.this.onMessage(msg);
			}
		});
	}
}
