/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: EndpointCallback.java 72784 2013-09-04 09:37:22Z supol $
 */

package com.sun.ts.tests.websocket.common.client;

import java.util.concurrent.CountDownLatch;

import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.MessageHandler.Whole;
import javax.websocket.Session;

/**
 * Default empty implementation of merged functionality of {@link Endpoint}
 * interface with {@link MessageHandler} interface. </p> Depending on what
 * {@link WebSocketCommonClient.Entity} is defined (partial, whole),
 * {@link Whole} or {@link MessageHandler.Partial} functionality is used with
 * onMessage
 */
public class EndpointCallback {

	public void onError(Session session, Throwable t) {
	}

	public void onMessage(Object o) {
	}

	public void onOpen(Session session, EndpointConfig config) {
	}

	public void onClose(Session session, CloseReason closeReason) {
	}

	public CountDownLatch getCountDownLatch() {
		return ClientEndpoint.getCountDownLatch();
	}

	public StringBuffer getMessageBuilder() {
		return ClientEndpoint.getMessageBuilder();
	}
	
	public Throwable getLastError() {
		return ClientEndpoint.getLastError();
	}
}
