/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: InitDestroyBinaryDecoder.java 71440 2013-04-05 15:03:30Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.coder;

import java.nio.ByteBuffer;

import javax.websocket.DecodeException;
import javax.websocket.EndpointConfig;

import com.sun.ts.tests.websocket.common.stringbean.StringBean;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanBinaryDecoder;

public class InitDestroyBinaryDecoder extends StringBeanBinaryDecoder {
	@Override
	public void init(EndpointConfig config) {
		Logger.onInit(getClass());
	}

	@Override
	public void destroy() {
		Logger.onDestroy(getClass());
	}
	
	@Override
	public StringBean decode(ByteBuffer arg0) throws DecodeException {
		Logger.onCode(getClass());
		return super.decode(arg0);
	};
	
	@Override
	public boolean willDecode(ByteBuffer arg0) {
		Logger.onWillCode(getClass());
		return super.willDecode(arg0);
	}	
}
