/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: InitDestroyBinaryStreamEncoder.java 71440 2013-04-05 15:03:30Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.coder;

import java.io.IOException;
import java.io.OutputStream;

import javax.websocket.EncodeException;
import javax.websocket.EndpointConfig;

import com.sun.ts.tests.websocket.common.stringbean.StringBean;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanBinaryStreamEncoder;

public class InitDestroyBinaryStreamEncoder extends
		StringBeanBinaryStreamEncoder {
	@Override
	public void init(EndpointConfig config) {
		Logger.onInit(getClass());
	}

	@Override
	public void destroy() {
		Logger.onDestroy(getClass());
	}

	@Override
	public void encode(StringBean bean, OutputStream stream)
			throws EncodeException, IOException {
		Logger.onCode(getClass());
		super.encode(bean, stream);
	}
}
