/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: AppConfig.java 71269 2013-03-31 15:56:19Z supol $
 */
package com.sun.ts.tests.websocket.ee.javax.websocket.server.serverendpointconfig;

import java.util.HashSet;
import java.util.Set;

import javax.websocket.Endpoint;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerEndpointConfig;

public class AppConfig implements ServerApplicationConfig {

	@Override
	public Set<ServerEndpointConfig> getEndpointConfigs(
			Set<Class<? extends Endpoint>> endpointClasses) {
		Set<ServerEndpointConfig> set = new HashSet<ServerEndpointConfig>();
		set.add(new SubprotocolsServerEndpointConfig());
		set.add(new ConfiguratorServerEndpointConfig());
		set.add(new ExtensionsServerEndpointConfig());
		return set;
	}

	@Override
	public Set<Class<?>> getAnnotatedEndpointClasses(Set<Class<?>> scanned) {
		Set<Class<?>> set = new HashSet<Class<?>>();
		set.add(WSAnnotatedSubprotocolsServer.class);
		set.add(WSAnnotatedConfiguratorServer.class);
		return set;
	}
}
