/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: WSCloseTestServer.java 71459 2013-04-07 03:31:16Z djiao $
 */
package com.sun.ts.tests.websocket.ee.javax.websocket.session;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.websocket.*;
import javax.websocket.server.ServerEndpoint;

@ServerEndpoint(value = "/WSCloseTestServer")
public class WSCloseTestServer {

        private static final Class<?>[] TEST_ARGS = {String.class, Session.class};
        static String testName;

        @OnOpen
        public void init(Session session) throws IOException {
                session.getBasicRemote().sendText("========WSCloseTestServer opened");
                if (session.isOpen()) {
                        session.getBasicRemote().sendText(
                                "========session from WSCloseTestServer is open=TRUE");
                } else {
                        session.getBasicRemote().sendText(
                                "========session from WSCloseTestServer is open=FALSE");
                }
        }

        @OnMessage
        public void respondString(String message, Session session) {
                System.out.println("WSCloseTestServer got String message: " + message);
                try {
                        if (message.startsWith("testName=") && message.endsWith("Test")) {
                                testName = message.substring(9);
                                Method method = WSCloseTestServer.class.getMethod(testName,
                                        TEST_ARGS);
                                method.invoke(this, new Object[]{message, session});
                        } else {
                                session.getBasicRemote().sendText(
                                        "========WSCloseTestServer received String:" + message);
                                session.getBasicRemote().sendText(
                                        "========WSCloseTestServer responds, please close your session");
                        }
                } catch (InvocationTargetException ite) {
                        System.err.println("Cannot run method " + testName);
                        ite.printStackTrace();
                } catch (NoSuchMethodException nsme) {
                        System.err.println("Test: " + testName + " does not exist");
                        nsme.printStackTrace();
                } catch (Exception e) {
                        e.printStackTrace();
                }
        }

        @OnError
        public void onError(Session session, Throwable t) {
                try {
                        session.getBasicRemote().sendText("========WSCloseTestServer onError");
                        if (session.isOpen()) {
                                session.getBasicRemote().sendText(
                                        "========onError: session from WSCloseTestServer is open=TRUE");
                        } else {
                                session.getBasicRemote().sendText(
                                        "========onError: session from WSCloseTestServer is open=FALSE");
                        }
                } catch (Exception e) {
                        e.printStackTrace();
                }
                t.printStackTrace();
        }

        @OnClose
        public void onClose() {
                System.out.println("==From WSCloseTestServer onClose()==");
        }

        public void close1Test(String message, Session session) {
                try {
                        session.getBasicRemote().sendText(
                                "========WSCloseTestServer received String: " + message);
                        session.close();
                } catch (IOException ex) {
                        ex.printStackTrace();
                }
        }

        public void close2Test(String message, Session session) {
                try {
                        session.getBasicRemote().sendText(
                                "========WSCloseTestServer received String: " + message);
                        session.close(new CloseReason(CloseReason.CloseCodes.TOO_BIG,
                                "TCKCloseNowWithReason"));
                } catch (IOException ex) {
                        ex.printStackTrace();
                }
        }

        public void close3Test(String message, Session session) {
                try {
                        session.getBasicRemote().sendText(
                                "========WSCloseTestServer received String: " + message);
                        session.close(new CloseReason(CloseReason.CloseCodes.TOO_BIG,
                                "TCKCloseNowWithReason"));
                } catch (IOException ex) {
                        ex.printStackTrace();
                }
        }
}