/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: MixedProgramaticEndpoint.java 73928 2014-08-01 09:35:37Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.session11.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.LinkedList;

import javax.websocket.EndpointConfig;
import javax.websocket.PongMessage;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.client.ClientEndpoint;
import com.sun.ts.tests.websocket.common.client.SendMessageCallback;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient.Entity;
import com.sun.ts.tests.websocket.common.stringbean.StringBean;
import com.sun.ts.tests.websocket.ee.javax.websocket.session11.common.StringList;
import com.sun.ts.tests.websocket.ee.javax.websocket.session11.common.TypeEnum;

public class MixedProgramaticEndpoint extends ClientEndpoint<String> {

	TypeEnum type;
	Entity entity;

	public MixedProgramaticEndpoint(TypeEnum type, Entity entity) {
		this.type = type;
		this.entity = entity;
	}

	@Override
	@SuppressWarnings("unchecked")
	public void onOpen(Session session, EndpointConfig config) {
		switch (type) {
		case LINKEDLIST_HASHSET_TEXT:
			LinkedList<HashSet<String>> list = new LinkedList<HashSet<String>>();

			Class<LinkedList<HashSet<String>>> clzLLHS = (Class<LinkedList<HashSet<String>>>) list
					.getClass();
			session.addMessageHandler(clzLLHS,
					new LinkedListHashSetMessageHandler(this));
			break;
		case LIST_TEXT:
			session.addMessageHandler(StringList.class,
					new StringListWholeMessageHandler(this));
			break;
		case STRINGBEAN:
			session.addMessageHandler(StringBean.class,
					new StringBeanMessageHandler(this));
			break;
		case STRING_WHOLE:
			session.addMessageHandler(String.class,
					new StringTextMessageHandler(this));
			break;
		case STRING_PARTIAL:
			session.addMessageHandler(String.class,
					new StringPartialMessageHandler(this));
			break;
		case READER:
			session.addMessageHandler(Reader.class, new ReaderMessageHandler(
					this));
			break;
		case PONG:
			session.addMessageHandler(PongMessage.class,
					new PongMessageHandler(this));
			// send pingmessage to receive pongmessage
			break;
		case BYTEBUFFER_WHOLE:
			session.addMessageHandler(ByteBuffer.class,
					new ByteBufferMessageHandler(this));
			break;
		case BYTEBUFFER_PARTIAL:
			session.addMessageHandler(ByteBuffer.class,
					new ByteBufferPartialMessageHandler(this));
			break;
		case BYTEARRAY_WHOLE:
			byte[] ba = new byte[0];
			Class<byte[]> baclz = (Class<byte[]>) ba.getClass();
			session.addMessageHandler(baclz, new ByteArrayMessageHandler(this));
			break;
		case BYTEARRAY_PARTIAL:
			ba = new byte[0];
			baclz = (Class<byte[]>) ba.getClass();
			session.addMessageHandler(baclz,
					new ByteArrayPartialMessageHandler(this));
			break;
		case INPUTSTREAM:
			session.addMessageHandler(InputStream.class,
					new InputStreamMessageHandler(this));
			break;
		default:
			break;
		}
		new SendMessageCallback(entity).onOpen(session, config);
	}

	public void sendMessage(Session session) {
		try {
			session.getBasicRemote().sendText(
					entity.getEntityAt(String.class, 0));
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}
}
