/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: ReaderMessageHandler.java 73930 2014-08-01 17:07:43Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.session11.server;

import java.io.IOException;
import java.io.Reader;

import javax.websocket.MessageHandler;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.util.IOUtil;

public class ReaderMessageHandler implements MessageHandler.Whole<Reader>{
	
	public static final String HANDLER_SAYS = "ReaderMessageHandler says: ";
	protected Session session;

	public ReaderMessageHandler(Session session) {
		this.session = session;
	}	
	
	@Override
	public void onMessage(Reader message) {
		String msg = null;
		try {
			msg = IOUtil.readFromReader(message);
			session.getBasicRemote().sendText(HANDLER_SAYS + msg);
		} catch (IOException e) {
			throw new RuntimeException(e); 
		}
	}
}
