/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: StringPartialMessageHandler.java 73930 2014-08-01 17:07:43Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.session11.server;

import java.io.IOException;

import javax.websocket.MessageHandler;
import javax.websocket.Session;

public class StringPartialMessageHandler implements
		MessageHandler.Partial<String> {

	protected Session session;
	public static final String HANDLER_SAYS = "StringPartialMessageHandler says: ";
	StringBuilder sb = new StringBuilder();

	public StringPartialMessageHandler(Session session) {
		super();
		this.session = session;
	}

	@Override
	public void onMessage(String message, boolean finite) {
		sb.append(message);
		try {
			if (finite)
				session.getBasicRemote().sendText(HANDLER_SAYS + sb.toString());
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

}
