/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSByteBufferAndSessionAndPathParamServer.java 72135 2013-06-13 09:13:43Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.websocketmessage;

import java.io.IOException;
import java.nio.ByteBuffer;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.util.IOUtil;

@ServerEndpoint("/bytebuffersessionpathparam/{param}")
public class WSByteBufferAndSessionAndPathParamServer {
	@OnMessage
	public String echo(ByteBuffer b, @PathParam("param") String param, Session s) {
		return IOUtil.byteBufferToString(b) + param;
	}
	
    @OnError
    public void onError(Session session, Throwable t) throws IOException {
    	System.out.println("@OnError in" + getClass().getName());
    	t.printStackTrace(); //Write to error log, too
    	String message = "Exception: " + IOUtil.printStackTrace(t);
    	session.getBasicRemote().sendText(message);
    }	
	
}
