/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: AnnotatedClientEndpointSuperclassWithAnnotations.java 73530 2014-02-24 22:26:16Z supol $
 */

package com.sun.ts.tests.websocket.spec.annotation.inheritance;

import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.client.AnnotatedClientEndpoint;
import com.sun.ts.tests.websocket.common.client.StringClientEndpoint;

public class AnnotatedClientEndpointSuperclassWithAnnotations extends
		AnnotatedClientEndpoint<String> {

	public AnnotatedClientEndpointSuperclassWithAnnotations() {
		super(new StringClientEndpoint());
	}

	@OnOpen
	public void onOpen(Session session, EndpointConfig config) {
		super.onOpen(session, config);
	}

	@OnMessage
	public void onMessage(String msg) {
		super.onMessage(msg);
	}

	@OnClose
	public void onClose(Session session, CloseReason closeReason) {
		super.onClose(session, closeReason);
	}

	@OnError
	public void onError(Session session, Throwable t) {
		super.onError(session, t);
	}
}
