/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.apicover;

import com.sun.tdk.apicover.APIVisitor;
import com.sun.tdk.apicover.RefCounter;
import com.sun.tdk.apicover.ReportPlain;
import com.sun.tdk.apicover.ReportXML;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.model.PackageDescr;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class ReportGenerator
extends APIVisitor {
    protected RefCounter refCounter;
    private PrintWriter log;
    int detail = 2;
    FIELD_MODE fieldMode = FIELD_MODE.NOCONST;
    Set<EXLUDE_MODE> excludeMode = new HashSet<EXLUDE_MODE>();
    Map<String, String[]> config;
    Map<String, Field> results = new HashMap<String, Field>();
    Collection<String> xList = new ArrayList<String>();
    protected PrintWriter pw;
    private static final String[] consttypes = new String[]{"boolean", "byte", "short", "int", "long", "char", "float", "double", "java.lang.String"};

    public void setLog(PrintWriter log) {
        this.log = log;
    }

    protected ReportGenerator(RefCounter refCounter) {
        this.setReportfile(null);
        this.refCounter = refCounter;
        this.config = new HashMap<String, String[]>();
    }

    public void setDetail(int detail) {
        this.detail = detail;
    }

    public void addConfig(String key, String value) {
        this.config.put(key, new String[]{value});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addXList(String[] names) {
        for (String name : names) {
            BufferedReader in = null;
            try {
                String line;
                in = new BufferedReader(new FileReader(name));
                while ((line = in.readLine()) != null) {
                    if (line.trim().startsWith("#")) continue;
                    this.xList.add(line);
                }
                this.addConfig("-excludeList", name);
            }
            catch (IOException e) {
                this.log.println(e.getMessage());
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        this.log.println(e.getMessage());
                    }
                }
            }
        }
    }

    public abstract void print();

    ReportGenerator createReportGenerator(String type, PrintWriter log) {
        ReportGenerator newReportGenerator = type.equals("plain") ? new ReportPlain(this.refCounter) : new ReportXML(this.refCounter);
        newReportGenerator.config = this.config;
        newReportGenerator.detail = this.detail;
        newReportGenerator.excludeMode = this.excludeMode;
        newReportGenerator.fieldMode = this.fieldMode;
        newReportGenerator.pw = this.pw;
        newReportGenerator.results = this.results;
        newReportGenerator.top = this.top;
        newReportGenerator.xList = this.xList;
        newReportGenerator.setLog(log);
        return newReportGenerator;
    }

    static ReportGenerator createReportGenerator(RefCounter ref, PrintWriter log) {
        ReportPlain rg = new ReportPlain(ref);
        rg.setLog(log);
        return rg;
    }

    protected static String classRepr(ClassDescription cd) {
        String name = cd.getQualifiedName();
        name = name.substring(name.lastIndexOf(46) + 1);
        return name;
    }

    protected boolean isConstType(String s) {
        for (String consttype : consttypes) {
            if (!consttype.equals(s)) continue;
            return true;
        }
        return false;
    }

    public void setConstatnChecking(boolean check) {
        this.fieldMode = check ? FIELD_MODE.ALL : FIELD_MODE.NOCONST;
    }

    public void excludeInterfaces() {
        this.excludeMode.add(EXLUDE_MODE.EXCLUDEINTERFACES);
    }

    public void excludeAbstractClasses() {
        this.excludeMode.add(EXLUDE_MODE.EXCLUDEABSTRACTCLASSES);
    }

    public void excludeAbstractMethods() {
        this.excludeMode.add(EXLUDE_MODE.EXCLUDEABSTRACTMETHODS);
    }

    public void excludeFields() {
        this.excludeMode.add(EXLUDE_MODE.EXCLUDEFIELD);
    }

    public void setReportfile(String reportfile) {
        try {
            this.pw = reportfile == null ? new PrintWriter(System.out) : new PrintWriter(new FileOutputStream(reportfile));
        }
        catch (FileNotFoundException e) {
            this.log.println(e);
        }
    }

    private boolean isExcluded(String str) {
        return this.xList.contains(str);
    }

    private void filter() {
        APIVisitor calc = new APIVisitor(){

            @Override
            protected void visit(ClassDescription cd) {
                Iterator i = cd.getMembersIterator();
                while (i.hasNext()) {
                    MemberDescription md = (MemberDescription)i.next();
                    if (!(md.isConstructor() || md.isField() || md.isMethod())) {
                        i.remove();
                        continue;
                    }
                    if (ReportGenerator.this.fieldMode == FIELD_MODE.NOCONST && md.isField() && md.hasModifier(Modifier.FINAL) && md.hasModifier(Modifier.STATIC) && ReportGenerator.this.isConstType(md.getType())) {
                        i.remove();
                        continue;
                    }
                    if (ReportGenerator.this.excludeMode.contains((Object)EXLUDE_MODE.EXCLUDEFIELD) && md.isField()) {
                        i.remove();
                        continue;
                    }
                    if (ReportGenerator.this.excludeMode.contains((Object)EXLUDE_MODE.EXCLUDEABSTRACTMETHODS) && md.isAbstract()) {
                        i.remove();
                        continue;
                    }
                    if (md.hasModifier(Modifier.FINAL) && !md.getDeclaringClassName().equals(cd.getQualifiedName())) {
                        i.remove();
                        continue;
                    }
                    if (!ReportGenerator.this.isExcluded(cd.getQualifiedName() + "." + md.getName() + (md.isField() ? "" : "(" + md.getArgs() + ")"))) continue;
                    i.remove();
                }
                int members = 0;
                int tested = 0;
                Iterator i2 = cd.getMembersIterator();
                while (i2.hasNext()) {
                    MemberDescription md = (MemberDescription)i2.next();
                    ++members;
                    if (!ReportGenerator.this.refCounter.isCovered(md)) continue;
                    ++tested;
                }
                ReportGenerator.this.results.put(cd.toString(), new Field(members, tested));
            }

            @Override
            protected void visit(PackageDescr pd) {
                int members = 0;
                int tested = 0;
                int classes = 0;
                for (Object o : pd.getDeclaredClasses()) {
                    ClassDescription cd = (ClassDescription)o;
                    this.visit(cd);
                    members += ReportGenerator.this.results.get((Object)cd.toString()).members;
                    tested += ReportGenerator.this.results.get((Object)cd.toString()).tested;
                    ++classes;
                }
                for (Object o : pd.getDeclaredPackages()) {
                    PackageDescr sub = (PackageDescr)o;
                    this.visit(sub);
                    members += ReportGenerator.this.results.get((Object)sub.toString()).members;
                    tested += ReportGenerator.this.results.get((Object)sub.toString()).tested;
                    classes += ReportGenerator.this.results.get((Object)sub.toString()).classes;
                }
                ReportGenerator.this.results.put(pd.toString(), new Field(classes, members, tested));
            }
        };
        Iterator it = this.api.iterator();
        while (it.hasNext()) {
            ClassDescription cd = (ClassDescription)it.next();
            if (this.excludeMode.contains((Object)EXLUDE_MODE.EXCLUDEABSTRACTCLASSES) && cd.isAbstract()) {
                it.remove();
                continue;
            }
            if (this.excludeMode.contains((Object)EXLUDE_MODE.EXCLUDEINTERFACES) && cd.isInterface()) {
                it.remove();
                continue;
            }
            if (!this.isExcluded(cd.getQualifiedName()) && !this.isExcluded(cd.getPackageName())) continue;
            it.remove();
        }
        calc.visit(this.api);
    }

    void out() {
        this.api = new ArrayList();
        this.api.addAll(this.refCounter.getClasses());
        this.filter();
        this.print();
    }

    static enum FIELD_MODE {
        NOCONST,
        ALL;

    }

    static enum EXLUDE_MODE {
        EXCLUDEINTERFACES,
        EXCLUDEABSTRACTCLASSES,
        EXCLUDEABSTRACTMETHODS,
        EXCLUDEFIELD;

    }

    protected static class Field {
        int classes;
        int members;
        int tested;

        Field(int members, int tested) {
            this.members = members;
            this.tested = tested;
        }

        Field(int classes, int members, int tested) {
            this.members = members;
            this.tested = tested;
            this.classes = classes;
        }

        String getPercent() {
            return this.members == 0 ? "" : this.tested * 100 / this.members + "%";
        }
    }
}

