/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.api.jakarta_servlet.jsp.jspwriter;

import com.sun.ts.tests.common.webclient.WebTestCase;
import com.sun.ts.tests.common.webclient.http.HttpResponse;
import com.sun.ts.tests.common.webclient.validation.TokenizedValidator;
import java.util.List;

public class JspWriterValidator
extends TokenizedValidator {
    private static final System.Logger logger = System.getLogger(JspWriterValidator.class.getName());
    private static final String UNIX_LINE_SEPARATOR = "\n";
    private static final String WIN32_LINE_SEPARATOR = "\r\n";
    private static final String EOL_HEADER = "Server-EOL";

    public boolean validate(WebTestCase testCase) {
        String eol = null;
        String eolToken = "#eol#";
        HttpResponse response = testCase.getResponse();
        eol = "UNIX".equals(response.getResponseHeader(EOL_HEADER)) ? UNIX_LINE_SEPARATOR : ("WIN32".equals(response.getResponseHeader(EOL_HEADER)) ? WIN32_LINE_SEPARATOR : System.getProperty("line.separator"));
        List searchList = testCase.getSearchStrings();
        int size = searchList.size();
        for (int i = 0; i < size; ++i) {
            String string = (String)searchList.get(i);
            logger.log(System.Logger.Level.TRACE, "[JspWriterValidator] Processing search string: " + string);
            int index = string.indexOf(eolToken);
            while (index > -1) {
                StringBuffer sb = new StringBuffer(string);
                sb.replace(index, index + 5, eol);
                string = sb.toString();
                index = string.indexOf(eolToken);
            }
            logger.log(System.Logger.Level.TRACE, "[JspWriterValidator] Adding (possibly) modified search string: " + string);
            searchList.set(i, string);
        }
        return super.validate(testCase);
    }
}

