/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.core_syntax.scripting.el;

import ee.jakarta.tck.pages.common.util.JspTestUtil;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.TagSupport;
import java.io.IOException;
import java.util.ArrayList;

public abstract class BaseCheckTag
extends TagSupport {
    protected Object _object = null;
    protected String _name = null;
    protected Object _control = null;
    private String _message = null;
    private boolean _display = false;

    public String getMessage() {
        return this._message;
    }

    public void setDisplay(boolean display) {
        this._display = display;
    }

    public void setObject(Object o) {
        this._object = o;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setControl(Object o) {
        this._control = o;
    }

    public int doStartTag() throws JspException {
        this.performCheck();
        return 1;
    }

    protected abstract void performCheck() throws JspException;

    protected void displayTestStatus(String message) throws JspException {
        if (this._display) {
            JspWriter out = this.pageContext.getOut();
            try {
                out.println();
                String[] messages = this.checkAncestorsForErrors();
                if (messages.length == 0) {
                    out.println("Test PASSED");
                }
                for (int i = 0; i < messages.length; ++i) {
                    out.println(messages[i]);
                }
            }
            catch (IOException ioe) {
                throw new JspException("Unexpected IOException!", (Throwable)ioe);
            }
        } else {
            this._message = message;
        }
    }

    private String[] checkAncestorsForErrors() {
        ArrayList<String> list = new ArrayList<String>();
        BaseCheckTag.debug("Checking parent tags for errors...");
        for (BaseCheckTag parent = (BaseCheckTag)this.getParent(); parent != null; parent = (BaseCheckTag)parent.getParent()) {
            String message = parent.getMessage();
            if (message != null) {
                BaseCheckTag.debug("Error: " + message);
                list.add(message);
            }
            BaseCheckTag.debug("Check of parent tag [" + parent + "] completed.");
        }
        return list.toArray(new String[list.size()]);
    }

    private static void debug(String message) {
        JspTestUtil.debug("[BaseCheckTag] " + message);
    }
}

