/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.dynamicattributes;

import ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.dynamicattributes.DynamicAttributesTag;
import ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.dynamicattributes.SimpleExcTag;
import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import ee.jakarta.tck.pages.common.util.JspTestUtil;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    public URLClientIT() throws Exception {
        this.setContextRoot("/jsp_bodytagsupp_web");
        this.setTestJsp("BodyTagSupportApiTest");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_dynattrib_web.war");
        archive.addClasses(new Class[]{DynamicAttributesTag.class, SimpleExcTag.class, JspTestUtil.class});
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_dynattrib_web.xml"));
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/dynamicattributes.tld", "dynamicattributes.tld");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/SetDynamicAttributesTest.jsp")), "SetDynamicAttributesTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/DynamicAttributesExceptionTest.jsp")), "DynamicAttributesExceptionTest.jsp");
        return archive;
    }

    @Test
    public void dynamicAttributesTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_dynattrib_web/SetDynamicAttributesTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        TEST_PROPS.setProperty("unexpected_response_match", "Test FAILED");
        this.invoke();
    }

    @Test
    public void dynamicAttributesExceptionTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_dynattrib_web/DynamicAttributesExceptionTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Classic - Test PASSED");
        TEST_PROPS.setProperty("search_string", "Simple - Test PASSED");
        TEST_PROPS.setProperty("unexpected_response_match", "Test FAILED");
        this.invoke();
    }
}

