/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.servlet3.rs.applicationpath;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.servlet3.rs.applicationpath.Resource;
import ee.jakarta.tck.ws.rs.servlet3.rs.applicationpath.TSAppConfig;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 1L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_applicationpath");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_applicationpath.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class});
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void applicationPathAnnotationEncodedTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "ApplicationPath!/Resource"));
        this.invoke();
    }

    @Test
    public void applicationPathAnnotationNotUsedTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "Resource"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, "-1");
        this.invoke();
        Response.Status status = this.getResponseStatusCode();
        Assertions.assertTrue((status != Response.Status.OK && status != Response.Status.NO_CONTENT ? 1 : 0) != 0, (String)("unexpected status code received " + status));
        JAXRSClientIT.logMsg("Received expected status code", status);
    }
}

