/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.spec.errorpage;

import java.util.Properties;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import servlet.tck.common.client.AbstractTckTest;
import servlet.tck.common.servlets.CommonServlets;
import servlet.tck.spec.errorpage.SecondServletErrorPage;
import servlet.tck.spec.errorpage.ServletErrorPage;
import servlet.tck.spec.errorpage.TestException;
import servlet.tck.spec.errorpage.TestServlet;
import servlet.tck.spec.errorpage.WrappedException;

public class ErrorPageTests
extends AbstractTckTest {
    @BeforeEach
    public void setupServletName() throws Exception {
        this.setServletName("TestServlet");
    }

    @Deployment(testable=false)
    public static WebArchive getTestArchive() throws Exception {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"servlet_spec_errorpage_web.war")).addAsWebResource("spec/errorpage/HTMLErrorPage.html", "HTMLErrorPage.html")).addAsLibraries((Archive[])CommonServlets.getCommonServletsArchive())).addClasses(new Class[]{SecondServletErrorPage.class, ServletErrorPage.class, TestException.class, TestServlet.class, WrappedException.class})).setWebXML(ErrorPageTests.class.getResource("servlet_spec_errorpage_web.xml"));
    }

    @Test
    public void servletToDifferentErrorPagesTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "servletErrorPageTest");
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "500");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Servlet Name: TestServlet|Request URI: /servlet_spec_errorpage_web/TestServlet|Status Code: 500|Exception Type: java.lang.IllegalStateException|Exception: java.lang.IllegalStateException: error page invoked|Message: error page invoked");
        ((Properties)TEST_PROPS.get()).setProperty("unexpected_response_match", "Test FAILED");
        this.invoke();
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "htmlErrorPageTest");
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "500");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "<html>|<head>|<title>HTML Error Page</title>|</head>|<body>|Error page mechanism invoked.|</body>|</html>");
        ((Properties)TEST_PROPS.get()).setProperty("unexpected_response_match", "Test FAILED");
        this.invoke();
    }

    @Test
    public void statusCodeErrorPageTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "statusCodeErrorPageTest");
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "501");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Servlet Name: TestServlet|Request URI: /servlet_spec_errorpage_web/TestServlet|Status Code: 501|Exception Type: null|Exception: null|Message: error page invoked");
        ((Properties)TEST_PROPS.get()).setProperty("unexpected_response_match", "Test FAILED");
        this.invoke();
    }

    @Test
    public void heirarchyErrorMatchTest() throws Exception {
        ((Properties)TEST_PROPS.get()).setProperty("apitest", "heirarchyErrorMatchTest");
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "500");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Servlet Name: TestServlet|Request URI: /servlet_spec_errorpage_web/TestServlet|Status Code: 500|Exception Type: java.lang.IllegalThreadStateException|Exception: java.lang.IllegalThreadStateException: error page invoked|Message: error page invoked");
        ((Properties)TEST_PROPS.get()).setProperty("unexpected_response_match", "Test FAILED");
        this.invoke();
    }

    @Test
    public void wrappedExceptionTest() throws Exception {
        String testName = "WrappedException";
        ((Properties)TEST_PROPS.get()).setProperty("testname", testName);
        ((Properties)TEST_PROPS.get()).setProperty("status-code", "500");
        ((Properties)TEST_PROPS.get()).setProperty("search_string", "Second ErrorPage|Servlet Name: WrappedException|Request URI: /servlet_spec_errorpage_web/WrappedException|Status Code: 500|Exception Type: servlet.tck.spec.errorpage.TestException|Exception: servlet.tck.spec.errorpage.TestException: error page invoked|Message: error page invoked");
        ((Properties)TEST_PROPS.get()).setProperty("unexpected_response_match", "Test FAILED");
        ((Properties)TEST_PROPS.get()).setProperty("request", "GET " + this.getContextRoot() + "/" + testName + " HTTP/1.1");
        this.invoke();
    }
}

