/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.common.response.validation;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import servlet.tck.common.client.handler.Handler;
import servlet.tck.common.client.handler.HandlerFactory;
import servlet.tck.common.request.Header;
import servlet.tck.common.request.HttpExchange;
import servlet.tck.common.request.HttpResponse;
import servlet.tck.common.request.ValidationStrategy;
import servlet.tck.common.request.WebTestCase;

public class WebValidatorBase
implements ValidationStrategy {
    private static final Logger logger = LoggerFactory.getLogger(WebValidatorBase.class);
    protected static final char CLIENT_ERROR = '4';
    protected static final char SERVER_ERROR = '5';
    protected HttpResponse _res = null;
    protected HttpExchange _req = null;
    protected WebTestCase _case = null;

    @Override
    public boolean validate(WebTestCase testCase) throws Exception {
        this._res = testCase.getResponse();
        this._req = testCase.getRequest();
        this._case = testCase;
        try {
            if (!(this.checkStatusCode() && this.checkReasonPhrase() && this.checkExpectedHeaders() && this.checkUnexpectedHeaders() && this.checkSearchStrings() && this.checkSearchStringsNoCase() && this.checkUnorderedSearchStrings() && this.checkUnexpectedSearchStrings())) {
                logger.error("Cannot validate response:" + testCase.getResponse());
                return false;
            }
        }
        catch (IOException ioe) {
            logger.error(" Unexpected Exception: " + ioe.getMessage(), (Throwable)ioe);
            return false;
        }
        return true;
    }

    protected boolean checkStatusCode() throws IOException {
        String[] sCodes;
        String sCode = this._case.getStatusCode();
        String resCode = this._res.getStatusCode();
        if ("-1".equals(sCode)) {
            return true;
        }
        if (sCode == null && resCode.charAt(0) == '4') {
            logger.error("Test {} Unexpected {} received from target server!  Request path: {}", new Object[]{this._case.getName(), resCode, this._req.getRequestPath()});
            return false;
        }
        if (sCode == null && resCode.charAt(0) == '5') {
            String resBody = this._res.getResponseBodyAsRawString();
            logger.error(" Test {} Unexpected '{}' received from target server!\n Error response received from server:\n------------------------------------------------\n {}", new Object[]{this._case.getName(), resCode, resBody != null ? resBody : "NO RESPONSE"});
            return false;
        }
        if (sCode == null) {
            return true;
        }
        boolean exclusions = sCode.charAt(0) == '!';
        String[] stringArray = sCodes = exclusions ? sCode.substring(1).split(",") : sCode.split(",");
        if (exclusions) {
            for (String current : sCodes) {
                if (!current.equals(resCode)) continue;
                logger.error(" Test {} Unexpected Status Code received from server.  Expected any value except '{}', received '{}'", new Object[]{this._case.getName(), sCode, resCode});
                return false;
            }
        } else {
            boolean found = false;
            for (String current : sCodes) {
                if (!current.equals(resCode)) continue;
                logger.debug(" Test {} Expected Status Code '{}' found in response line!", (Object)this._case.getName(), (Object)current);
                found = true;
                break;
            }
            if (!found) {
                logger.error(" Test {} Status Code '{}' not found in response line!", (Object)this._case.getName(), (Object)sCode);
                return false;
            }
        }
        return true;
    }

    protected boolean checkSearchStrings() throws Exception {
        List<String> list = this._case.getSearchStrings();
        boolean found = true;
        if (list != null && !list.isEmpty()) {
            String responseBody = this._res.getResponseBodyAsRawString();
            int n = list.size();
            int startIdx = 0;
            int bodyLength = responseBody.length();
            for (int i = 0; i < n; ++i) {
                if (startIdx >= bodyLength) {
                    startIdx = bodyLength;
                }
                String search = list.get(i);
                int searchIdx = responseBody.indexOf(search, startIdx);
                logger.debug(" Test {} Scanning response for search string: '{}' starting at index location: {}", new Object[]{this._case.getName(), search, startIdx});
                if (searchIdx < 0) {
                    found = false;
                    String sb = " Test %s Unable to find the following search string in the server's response: \n'%s'\n at index: %s\n Server's response:\n-------------------------------------------\n%s\n-------------------------------------------\n";
                    String result = String.format(sb, this._case.getName(), search, startIdx, responseBody);
                    logger.error(result);
                    throw new Exception(result);
                }
                logger.debug(" Test {} Found search string: '{}' at index '{}' in the server's response", new Object[]{this._case.getName(), search, searchIdx});
                startIdx = searchIdx + search.length();
            }
        }
        return found;
    }

    protected boolean checkSearchStringsNoCase() throws Exception {
        List<String> list = this._case.getSearchStringsNoCase();
        boolean found = true;
        if (list != null && !list.isEmpty()) {
            String responseBody = this._res.getResponseBodyAsRawString();
            int n = list.size();
            int startIdx = 0;
            int bodyLength = responseBody.length();
            for (int i = 0; i < n; ++i) {
                if (startIdx >= bodyLength) {
                    startIdx = bodyLength;
                }
                String search = list.get(i);
                int searchIdx = responseBody.toLowerCase().indexOf(search.toLowerCase(), startIdx);
                logger.debug(" Test {} Scanning response for search string: '{}' starting at index location: {}", new Object[]{this._case.getName(), search, startIdx});
                if (searchIdx < 0) {
                    found = false;
                    String sb = " Test %s Unable to find the following search string in the server's response: \n'%s'\n at index: %s\n Server's response:\n-------------------------------------------\n%s\n-------------------------------------------\n";
                    String result = String.format(sb, this._case.getName(), search, searchIdx, responseBody);
                    logger.error(result);
                    throw new Exception(result);
                }
                logger.debug(" Test {} Found search string: '{}' at index '{}' in the server's response", new Object[]{this._case.getName(), search, searchIdx});
                startIdx = searchIdx + search.length();
            }
        }
        return found;
    }

    protected boolean checkUnorderedSearchStrings() throws Exception {
        List<String> list = this._case.getUnorderedSearchStrings();
        boolean found = true;
        if (list != null && !list.isEmpty()) {
            String responseBody = this._res.getResponseBodyAsRawString();
            for (String search : list) {
                int searchIdx = responseBody.indexOf(search);
                logger.debug(" Test {} Scanning response for search string: '{}'...", (Object)this._case.getName(), (Object)search);
                if (searchIdx < 0) {
                    found = false;
                    String sb = " Test %s Unable to find the following search string in the server's response: \n' %s\n Server's response:\n-------------------------------------------\n%s\n-------------------------------------------\n";
                    String result = String.format(sb, this._case.getName(), search, responseBody);
                    logger.error(result);
                    throw new Exception(result);
                }
                logger.debug(" Test {} Found search string: '{}' at index '{}' in the server's response", new Object[]{this._case.getName(), search, searchIdx});
            }
        }
        return found;
    }

    protected boolean checkUnexpectedSearchStrings() throws IOException {
        List<String> list = this._case.getUnexpectedSearchStrings();
        if (list != null && !list.isEmpty()) {
            String responseBody = this._res.getResponseBodyAsRawString();
            for (String search : list) {
                logger.debug(" Test {} Scanning response. The following string should not be present in the response: '{}'", (Object)this._case.getName(), (Object)search);
                if (!responseBody.contains(search)) continue;
                String sb = " Test {} Found the following unexpected search string in the server's response: '{}'\n Server's response:\n-------------------------------------------\n{}}\n-------------------------------------------\n";
                logger.error(sb, new Object[]{this._case.getName(), search, responseBody});
                return false;
            }
        }
        return true;
    }

    protected boolean checkReasonPhrase() {
        String sReason = this._case.getReasonPhrase();
        String resReason = this._res.getReasonPhrase();
        if (sReason == null) {
            return true;
        }
        boolean check = sReason.equalsIgnoreCase(resReason);
        if (check) {
            logger.debug("Test {}, found expected reasonPhrase is '{}'", (Object)this._case.getName(), (Object)resReason);
            return true;
        }
        logger.error("Test {}, reasonPhrase is '{}' but not '{}'", new Object[]{this._case.getName(), resReason, sReason});
        return false;
    }

    protected boolean checkExpectedHeaders() throws Exception {
        Header[] expected = this._case.getExpectedHeaders();
        if (this.isEmpty(expected)) {
            return true;
        }
        boolean found = true;
        Header currentHeader = null;
        for (Header header2 : expected) {
            currentHeader = header2;
            Optional<Header> resHeader = this._res.getResponseHeader(currentHeader.getName());
            if (resHeader.isPresent()) {
                Handler handler = HandlerFactory.getHandler(currentHeader.getName());
                if (handler.invoke(currentHeader, resHeader.get())) continue;
                found = false;
                break;
            }
            found = false;
            break;
        }
        if (!found) {
            StringBuilder sb = new StringBuilder(255);
            sb.append(" Test %s Unable to find the following header");
            sb.append(" in the server's response: ");
            sb.append("%s").append("\n");
            sb.append(" Response headers received from server:");
            List<Header> resHeaders = this._res.getResponseHeaders();
            sb.append(resHeaders.stream().map(header -> "ResponseHeader ->'" + header.getName() + "';'" + String.join((CharSequence)",", header.getValues()) + "'").collect(Collectors.joining("\n\t")));
            sb.append("\n");
            String result = String.format(sb.toString(), this._case.getName(), currentHeader);
            logger.error(result);
            throw new Exception(result);
        }
        logger.debug(" Test {} Found expected header: {}", (Object)this._case.getName(), (Object)currentHeader.toString());
        return true;
    }

    protected boolean checkUnexpectedHeaders() {
        Header[] unexpected = this._case.getUnexpectedHeaders();
        if (this.isEmpty(unexpected)) {
            return true;
        }
        for (Header currentHeader : unexpected) {
            String currName = currentHeader.getName();
            String currValue = currentHeader.getValue();
            Optional<Header> resHeader = this._res.getResponseHeader(currName);
            if (!resHeader.isPresent() || !resHeader.get().getValue().equals(currValue)) continue;
            StringBuilder sb = new StringBuilder(255);
            sb.append(" Test {} Unexpected header found in the ");
            sb.append("server's response: ");
            sb.append("{}").append("\n");
            sb.append(" Response headers received from");
            sb.append("server:");
            List<Header> resHeaders = this._res.getResponseHeaders();
            sb.append(resHeaders.stream().map(header -> "ResponseHeader ->" + header.getName() + ":" + String.join((CharSequence)",", header.getValues())).collect(Collectors.joining("\n\t")));
            logger.error(sb.toString(), (Object)this._case.getName(), (Object)currentHeader);
            return false;
        }
        return true;
    }

    protected boolean isEmpty(Header[] headers) {
        return headers == null || headers.length == 0;
    }
}

