/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.endpoint.client;

import com.sun.ts.tests.websocket.common.client.StringClientEndpoint;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.endpoint.client.OPS;
import jakarta.websocket.CloseReason;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.OnClose;
import jakarta.websocket.Session;

public class WSCErrorClientEndpoint
extends StringClientEndpoint {
    private static final String EXCEPTION = "TCK test throwable";
    boolean onErrorCalled = false;

    public void onMessage(String msg) {
        super.onMessage((Object)msg);
        OPS op = OPS.valueOf(msg);
        switch (op) {
            case THROW: {
                throw new RuntimeException(EXCEPTION);
            }
        }
    }

    public void onOpen(Session session, EndpointConfig config) {
        super.onOpen(session, config);
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        super.onClose(session, closeReason);
    }

    public void onError(Session session, Throwable t) {
        String msg = WebSocketCommonClient.getCauseMessage((Throwable)t);
        if (EXCEPTION.equals(msg)) {
            this.onErrorCalled = true;
            WSCErrorClientEndpoint.getCountDownLatch().countDown();
        } else {
            super.onError(session, t);
        }
    }
}

