/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.async;

import com.sun.ts.tests.websocket.common.impl.WaitingSendHandler;
import com.sun.ts.tests.websocket.common.stringbean.StringBean;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanTextEncoder;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.async.OPS;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.PongMessage;
import jakarta.websocket.RemoteEndpoint;
import jakarta.websocket.SendHandler;
import jakarta.websocket.SendResult;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;

@ServerEndpoint(value="/server", encoders={StringBeanTextEncoder.class})
public class WSCServerSideServer {
    private static final System.Logger logger = System.getLogger(WSCServerSideServer.class.getName());
    static final String[] RESPONSE = new String[]{"OK", "FAIL"};
    static final long SECONDS = 10L;

    @OnMessage
    public String onMessage(PongMessage pong) {
        return IOUtil.byteBufferToString((ByteBuffer)pong.getApplicationData());
    }

    @OnMessage
    public String onMessage(String msg, Session session) {
        RemoteEndpoint.Async asyncRemote = session.getAsyncRemote();
        OPS op = OPS.valueOf(msg.toUpperCase());
        switch (op) {
            case POKE: {
                break;
            }
            case TIMEOUT: {
                msg = WSCServerSideServer.timeout(asyncRemote);
                break;
            }
            case SENDBINARY: {
                msg = WSCServerSideServer.sendBinary(asyncRemote);
                break;
            }
            case SENDBINARYTHROWS: {
                msg = WSCServerSideServer.sendBinaryThrows(asyncRemote);
                break;
            }
            case SENDBINARYHANDLER: {
                msg = WSCServerSideServer.sendBinaryWithHandler(asyncRemote);
                break;
            }
            case SENDBINARYHANDLERTHROWSONDATA: {
                msg = WSCServerSideServer.sendBinaryWithHandlerThrowsOnData(asyncRemote);
                break;
            }
            case SENDBINARYHANDLERTHROWSONHANDLER: {
                msg = WSCServerSideServer.sendBinaryWithHandlerThrowsOnHandler(asyncRemote);
                break;
            }
            case SENDOBJECT: {
                msg = WSCServerSideServer.sendObject(asyncRemote);
                break;
            }
            case SENDOBJECT_BOOL: {
                msg = WSCServerSideServer.sendObject(asyncRemote, Boolean.TYPE);
                break;
            }
            case SENDOBJECT_BYTE: {
                msg = WSCServerSideServer.sendObject(asyncRemote, Byte.TYPE);
                break;
            }
            case SENDOBJECT_CHAR: {
                msg = WSCServerSideServer.sendObject(asyncRemote, Character.TYPE);
                break;
            }
            case SENDOBJECT_DOUBLE: {
                msg = WSCServerSideServer.sendObject(asyncRemote, Double.TYPE);
                break;
            }
            case SENDOBJECT_FLOAT: {
                msg = WSCServerSideServer.sendObject(asyncRemote, Float.TYPE);
                break;
            }
            case SENDOBJECT_INT: {
                msg = WSCServerSideServer.sendObject(asyncRemote, Integer.TYPE);
                break;
            }
            case SENDOBJECT_LONG: {
                msg = WSCServerSideServer.sendObject(asyncRemote, Long.TYPE);
                break;
            }
            case SENDOBJECT_SHORT: {
                msg = WSCServerSideServer.sendObject(asyncRemote, Short.TYPE);
                break;
            }
            case SENDOBJECTTHROWS: {
                msg = WSCServerSideServer.sendObjectThrows(asyncRemote);
                break;
            }
            case SENDOBJECTHANDLER: {
                msg = WSCServerSideServer.sendObjectWithHandler(asyncRemote);
                break;
            }
            case SENDOBJECTHANDLERTHROWSONDATA: {
                msg = WSCServerSideServer.sendObjectWithHandlerThrowsOnData(asyncRemote);
                break;
            }
            case SENDOBJECTHANDLERTHROWSONHANDLER: {
                msg = WSCServerSideServer.sendObjectWithHandlerThrowsOnHandler(asyncRemote);
                break;
            }
            case SENDTEXT: {
                msg = WSCServerSideServer.sendText(asyncRemote);
                break;
            }
            case SENDTEXTTHROWS: {
                msg = WSCServerSideServer.sendTextThrows(asyncRemote);
                break;
            }
            case SENDTEXTHANDLER: {
                msg = WSCServerSideServer.sendTextWithHandler(asyncRemote);
                break;
            }
            case SENDTEXTHANDLERTHROWSONDATA: {
                msg = WSCServerSideServer.sendTextWithHandlerThrowsOnData(asyncRemote);
                break;
            }
            case SENDTEXTHANDLERTHROWSONHANDLER: {
                msg = WSCServerSideServer.sendTextWithHandlerThrowsOnHandler(asyncRemote);
                break;
            }
            case BATCHING_ALLOWED: {
                msg = WSCServerSideServer.batchingAllowed(asyncRemote);
                break;
            }
            case SEND_PING: {
                msg = WSCServerSideServer.sendPing(asyncRemote);
                break;
            }
            case SEND_PING_THROWS: {
                msg = WSCServerSideServer.sendPingThrows(asyncRemote);
                break;
            }
            case SEND_PONG: {
                msg = WSCServerSideServer.sendPong(asyncRemote);
                break;
            }
            case SEND_PONG_THROWS: {
                msg = WSCServerSideServer.sendBinaryThrows(asyncRemote);
                break;
            }
            case IDLE: {
                session.setMaxIdleTimeout(1500L);
                break;
            }
            case PING_4_TIMES: {
                msg = WSCServerSideServer.sendPing4times(asyncRemote);
                break;
            }
            case PONG_4_TIMES: {
                msg = WSCServerSideServer.sendPong4times(asyncRemote);
                break;
            }
            default: {
                throw new IllegalArgumentException("Method " + msg + " not implemented");
            }
        }
        return msg;
    }

    @OnError
    public void onError(Session session, Throwable t) throws IOException {
        logger.log(System.Logger.Level.INFO, "@OnError in " + this.getClass().getName());
        t.printStackTrace();
        String message = "Exception: " + IOUtil.printStackTrace((Throwable)t);
        session.getBasicRemote().sendText(message);
    }

    protected static String timeout(RemoteEndpoint.Async asyncRemote) {
        boolean set = true;
        int timeout = 1;
        asyncRemote.setSendTimeout((long)timeout);
        set &= (long)timeout == asyncRemote.getSendTimeout();
        timeout = 5;
        asyncRemote.setSendTimeout((long)timeout);
        return (set &= (long)timeout == asyncRemote.getSendTimeout()) ? RESPONSE[0] : RESPONSE[1];
    }

    protected static String sendBinary(RemoteEndpoint.Async asyncRemote) {
        Future future = asyncRemote.sendBinary(ByteBuffer.wrap(OPS.SENDBINARY.name().getBytes()));
        try {
            Void v = (Void)future.get();
            return v == null ? RESPONSE[0] : RESPONSE[1];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace((Throwable)e);
        }
    }

    protected static String sendBinaryThrows(RemoteEndpoint.Async asyncRemote) {
        try {
            asyncRemote.sendBinary((ByteBuffer)null);
            return RESPONSE[1];
        }
        catch (IllegalArgumentException e) {
            return RESPONSE[0];
        }
    }

    protected static String sendBinaryWithHandler(RemoteEndpoint.Async asyncRemote) {
        WaitingSendHandler handler = new WaitingSendHandler();
        asyncRemote.sendBinary(ByteBuffer.wrap(OPS.SENDBINARYHANDLER.name().getBytes()), (SendHandler)handler);
        SendResult result = handler.waitForResult(10L);
        return result.isOK() ? RESPONSE[0] : RESPONSE[1];
    }

    protected static String sendBinaryWithHandlerThrowsOnData(RemoteEndpoint.Async asyncRemote) {
        try {
            asyncRemote.sendBinary((ByteBuffer)null, (SendHandler)new WaitingSendHandler());
            return RESPONSE[1];
        }
        catch (IllegalArgumentException e) {
            return RESPONSE[0];
        }
    }

    protected static String sendBinaryWithHandlerThrowsOnHandler(RemoteEndpoint.Async asyncRemote) {
        try {
            asyncRemote.sendBinary(ByteBuffer.wrap(OPS.SENDBINARYHANDLERTHROWSONDATA.name().getBytes()), (SendHandler)((WaitingSendHandler)null));
            return RESPONSE[1];
        }
        catch (IllegalArgumentException e) {
            return RESPONSE[0];
        }
    }

    protected static String sendObject(RemoteEndpoint.Async asyncRemote) {
        Future future = asyncRemote.sendObject((Object)new StringBean(OPS.SENDOBJECT.name()));
        try {
            Void v = (Void)future.get();
            return v == null ? RESPONSE[0] : RESPONSE[1];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace((Throwable)e);
        }
    }

    protected static String sendObject(RemoteEndpoint.Async asyncRemote, Class<?> type) {
        try {
            Future future = null;
            if (type == Byte.TYPE) {
                byte b = -100;
                future = asyncRemote.sendObject((Object)b);
            } else if (type == Short.TYPE) {
                short s = -101;
                future = asyncRemote.sendObject((Object)s);
            } else if (type == Integer.TYPE) {
                int i = -102;
                future = asyncRemote.sendObject((Object)i);
            } else if (type == Long.TYPE) {
                long l = -103L;
                future = asyncRemote.sendObject((Object)l);
            } else if (type == Float.TYPE) {
                float f = -104.0f;
                future = asyncRemote.sendObject((Object)Float.valueOf(f));
            } else if (type == Double.TYPE) {
                double d = -105.0;
                future = asyncRemote.sendObject((Object)d);
            } else if (type == Boolean.TYPE) {
                boolean b = false;
                future = asyncRemote.sendObject((Object)b);
            } else if (type == Character.TYPE) {
                char c = 'j';
                future = asyncRemote.sendObject((Object)Character.valueOf(c));
            }
            Void v = (Void)future.get();
            return v == null ? RESPONSE[0] : RESPONSE[1];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace((Throwable)e);
        }
    }

    protected static String sendObjectThrows(RemoteEndpoint.Async asyncRemote) {
        try {
            asyncRemote.sendObject((Object)null);
            return RESPONSE[1];
        }
        catch (IllegalArgumentException e) {
            return RESPONSE[0];
        }
    }

    protected static String sendObjectWithHandler(RemoteEndpoint.Async asyncRemote) {
        WaitingSendHandler handler = new WaitingSendHandler();
        asyncRemote.sendObject((Object)new StringBean(OPS.SENDOBJECTHANDLER.name()), (SendHandler)handler);
        SendResult result = handler.waitForResult(10L);
        return result.isOK() ? RESPONSE[0] : RESPONSE[1];
    }

    protected static String sendObjectWithHandlerThrowsOnData(RemoteEndpoint.Async asyncRemote) {
        try {
            asyncRemote.sendObject(null, (SendHandler)new WaitingSendHandler());
            return RESPONSE[1];
        }
        catch (IllegalArgumentException e) {
            return RESPONSE[0];
        }
    }

    protected static String sendObjectWithHandlerThrowsOnHandler(RemoteEndpoint.Async asyncRemote) {
        try {
            OPS op = OPS.SENDOBJECTHANDLERTHROWSONHANDLER;
            asyncRemote.sendObject((Object)op, (SendHandler)((WaitingSendHandler)null));
            return RESPONSE[1];
        }
        catch (IllegalArgumentException e) {
            return RESPONSE[0];
        }
    }

    protected static String sendText(RemoteEndpoint.Async asyncRemote) {
        Future future = asyncRemote.sendText(OPS.SENDTEXT.name());
        try {
            Void v = (Void)future.get();
            return v == null ? RESPONSE[0] : RESPONSE[1];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace((Throwable)e);
        }
    }

    protected static String sendTextThrows(RemoteEndpoint.Async asyncRemote) {
        try {
            asyncRemote.sendText((String)null);
            return RESPONSE[1];
        }
        catch (IllegalArgumentException e) {
            return RESPONSE[0];
        }
    }

    protected static String sendTextWithHandler(RemoteEndpoint.Async asyncRemote) {
        WaitingSendHandler handler = new WaitingSendHandler();
        asyncRemote.sendText(OPS.SENDTEXTHANDLER.name(), (SendHandler)handler);
        SendResult result = handler.waitForResult(10L);
        return result.isOK() ? RESPONSE[0] : RESPONSE[1];
    }

    protected static String sendTextWithHandlerThrowsOnData(RemoteEndpoint.Async asyncRemote) {
        try {
            asyncRemote.sendText((String)null, (SendHandler)new WaitingSendHandler());
            return RESPONSE[1];
        }
        catch (IllegalArgumentException e) {
            return RESPONSE[0];
        }
    }

    protected static String sendTextWithHandlerThrowsOnHandler(RemoteEndpoint.Async asyncRemote) {
        try {
            asyncRemote.sendText(OPS.SENDOBJECTHANDLERTHROWSONHANDLER.name(), (SendHandler)((WaitingSendHandler)null));
            return RESPONSE[1];
        }
        catch (IllegalArgumentException e) {
            return RESPONSE[0];
        }
    }

    protected static String batchingAllowed(RemoteEndpoint.Async asyncRemote) {
        try {
            boolean allowed = asyncRemote.getBatchingAllowed();
            asyncRemote.setBatchingAllowed(!allowed);
            asyncRemote.sendText(OPS.BATCHING_ALLOWED.name());
            asyncRemote.flushBatch();
            asyncRemote.setBatchingAllowed(allowed);
            return RESPONSE[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace((Throwable)e);
        }
    }

    protected static String sendPing(RemoteEndpoint.Async asyncRemote) {
        try {
            asyncRemote.sendPing(ByteBuffer.wrap(OPS.SEND_PING.name().getBytes()));
            return RESPONSE[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace((Throwable)e);
        }
    }

    protected static String sendPingThrows(RemoteEndpoint.Async asyncRemote) {
        try {
            asyncRemote.sendPing(ByteBuffer.wrap(WSCServerSideServer.generateMessage(126).getBytes()));
            return RESPONSE[1];
        }
        catch (IllegalArgumentException iae) {
            return RESPONSE[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace((Throwable)e);
        }
    }

    protected static String generateMessage(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i != length; ++i) {
            sb.append(i % 10);
        }
        return sb.toString();
    }

    protected static String sendPong(RemoteEndpoint.Async asyncRemote) {
        try {
            asyncRemote.sendPong(ByteBuffer.wrap(OPS.SEND_PONG.name().getBytes()));
            return RESPONSE[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace((Throwable)e);
        }
    }

    protected static String sendPongThrows(RemoteEndpoint.Async asyncRemote) {
        try {
            asyncRemote.sendPong(ByteBuffer.wrap(WSCServerSideServer.generateMessage(126).getBytes()));
            return RESPONSE[1];
        }
        catch (IllegalArgumentException iae) {
            return RESPONSE[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace((Throwable)e);
        }
    }

    protected static String sendPing4times(RemoteEndpoint.Async asyncRemote) {
        try {
            byte[] bytes = OPS.POKE.name().getBytes();
            asyncRemote.sendPing(ByteBuffer.wrap(bytes));
            Thread.sleep(500L);
            asyncRemote.sendPing(ByteBuffer.wrap(bytes));
            Thread.sleep(500L);
            asyncRemote.sendPing(ByteBuffer.wrap(bytes));
            Thread.sleep(500L);
            asyncRemote.sendPing(ByteBuffer.wrap(bytes));
            Thread.sleep(500L);
            return RESPONSE[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace((Throwable)e);
        }
    }

    protected static String sendPong4times(RemoteEndpoint.Async asyncRemote) {
        try {
            byte[] bytes = OPS.POKE.name().getBytes();
            asyncRemote.sendPong(ByteBuffer.wrap(bytes));
            Thread.sleep(500L);
            asyncRemote.sendPong(ByteBuffer.wrap(bytes));
            Thread.sleep(500L);
            asyncRemote.sendPong(ByteBuffer.wrap(bytes));
            Thread.sleep(500L);
            asyncRemote.sendPong(ByteBuffer.wrap(bytes));
            Thread.sleep(500L);
            return RESPONSE[0];
        }
        catch (Exception e) {
            e.printStackTrace();
            return IOUtil.printStackTrace((Throwable)e);
        }
    }
}

